# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id


@dataclass(kw_only=True)
class SlidingInterfaces(CodeRepr, ParamGroupWrapper[clientpb.SlidingInterfaces]):
    """Defines the two sides that form a sliding interface. The two sides are abutting, possibly in combination with a periodic transformation, and should have the same normal grid velocity. The tangential grid velocity can, and usually will, be different. Each side of the sliding interface can be composed out of an arbitrary number of surfaces."""

    id: str = field(default_factory=create_unique_id, init=False)
    "ID of the sliding interface."
    name: str = ""
    "Name of the sliding interface."
    surfaces_side_a: list[str] = field(default_factory=list)
    "Names of the surfaces of side A of the sliding interface."
    surfaces_side_b: list[str] = field(default_factory=list)
    "Names of the surfaces of side B of the sliding interface."
    interface_type: enum.InterfaceType = enum.InterfaceType.GENERAL_INTERFACE
    "Type of interface treatment."
    tim_thickness: LcFloat = 0
    "Thickness of the thermal interface material (TIM). Zero thickness implies perfect contact."
    tim_conductivity: LcFloat = 5
    "Thermal conductivity of the thermal interface material (TIM)."

    def _to_proto(self) -> clientpb.SlidingInterfaces:
        _proto = clientpb.SlidingInterfaces()
        if self.id is not None:
            _proto.sliding_interface_id = self.id
        if self.name is not None:
            _proto.sliding_interface_name = self.name
        if self.surfaces_side_a is not None:
            _proto.sliding_a.extend(self.surfaces_side_a)
        if self.surfaces_side_b is not None:
            _proto.sliding_b.extend(self.surfaces_side_b)
        _proto.interface_type = self.interface_type.value
        _proto.thermal_interface_material_thickness.CopyFrom(_to_ad_proto(self.tim_thickness))
        _proto.thermal_interface_material_conductivity.CopyFrom(_to_ad_proto(self.tim_conductivity))
        return _proto

    def _from_proto(self, proto: clientpb.SlidingInterfaces) -> None:
        self.id = proto.sliding_interface_id
        self.name = proto.sliding_interface_name
        self.surfaces_side_a.extend(proto.sliding_a)
        self.surfaces_side_b.extend(proto.sliding_b)
        self.interface_type = enum.InterfaceType(proto.interface_type)
        self.tim_thickness = _from_ad_proto(proto.thermal_interface_material_thickness)
        self.tim_conductivity = _from_ad_proto(proto.thermal_interface_material_conductivity)
        return None
