# Generated by generate_sdk_wrappers.py. DO NOT EDIT

from abc import ABC, ABCMeta
from dataclasses import dataclass, field
from typing import Any
from uuid import uuid4

from google.protobuf.message import Message as _Message
from luminarycloud.tables import RectilinearTable, _param_name_to_table_type
from luminarycloud.types import Vector3, LcFloat
from luminarycloud.types.adfloat import _to_ad_proto, _from_ad_proto
from luminarycloud._helpers._entity_identifier import _create_entity_identifier
from luminarycloud._proto.client import simulation_pb2 as clientpb
from luminarycloud._proto.client.entity_pb2 import EntityIdentifier
from luminarycloud._helpers import CodeRepr
import luminarycloud.params.enum._enum_wrappers as enum

from luminarycloud.params.simulation._lib import ParamGroupWrapper, create_unique_id

from luminarycloud.params.simulation.time.compute_statistics_ import ComputeStatistics
from luminarycloud.params.simulation.time.compute_statistics_ import *
from luminarycloud.params.simulation.time.compute_statistics.compute_statistics_off_ import (
    ComputeStatisticsOff,
)
from luminarycloud.params.simulation.time.compute_statistics.compute_statistics_off_ import *
from luminarycloud.params.simulation.time.compute_statistics.compute_statistics_on_ import (
    ComputeStatisticsOn,
)
from luminarycloud.params.simulation.time.compute_statistics.compute_statistics_on_ import *
from luminarycloud.params.simulation.time.time_marching.time_explicit_ import TimeExplicit
from luminarycloud.params.simulation.time.time_marching.time_explicit_ import *
from luminarycloud.params.simulation.time.time_marching.time_implicit_ import TimeImplicit
from luminarycloud.params.simulation.time.time_marching.time_implicit_ import *
from luminarycloud.params.simulation.time.time_marching_ import TimeMarching
from luminarycloud.params.simulation.time.time_marching_ import *
from luminarycloud.params.simulation.time.time_step_ramp_ import TimeStepRamp
from luminarycloud.params.simulation.time.time_step_ramp_ import *
from luminarycloud.params.simulation.time.time_step_ramp.time_step_ramp_off_ import TimeStepRampOff
from luminarycloud.params.simulation.time.time_step_ramp.time_step_ramp_off_ import *
from luminarycloud.params.simulation.time.time_step_ramp.time_step_ramp_on_ import TimeStepRampOn
from luminarycloud.params.simulation.time.time_step_ramp.time_step_ramp_on_ import *


@dataclass(kw_only=True)
class Time(CodeRepr, ParamGroupWrapper[clientpb.Time]):
    """Time parameters used by a transient solution (required if flow_behavior = transient)."""

    time_marching: TimeMarching = field(default_factory=TimeImplicit)
    "Scheme for time-accurate integration. Possible types: ``TimeImplicit``, ``TimeExplicit`` from the ``time_marching`` module."
    time_step: LcFloat = 0.0001
    "The fixed physical time step."
    time_step_ramp: TimeStepRamp = field(default_factory=TimeStepRampOff)
    "Use a larger time step value during the initial transients of a simulation and then ramp linearly towards the target value, to accelerate statistical convergence. Only applicable to transient problems with time implicit integration (dual time stepping). Possible types: ``TimeStepRampOff``, ``TimeStepRampOn`` from the ``time_step_ramp`` module."
    compute_statistics: ComputeStatistics = field(default_factory=ComputeStatisticsOff)
    "Compute time-averaged values of flow variables (e.g. Velocity). Possible types: ``ComputeStatisticsOff``, ``ComputeStatisticsOn`` from the ``compute_statistics`` module."

    def _to_proto(self) -> clientpb.Time:
        _proto = clientpb.Time()
        if isinstance(self.time_marching, TimeImplicit):
            _proto.time_marching = clientpb.TIME_IMPLICIT
            _proto.time_implicit_order = self.time_marching.time_implicit_order.value
        if isinstance(self.time_marching, TimeExplicit):
            _proto.time_marching = clientpb.TIME_EXPLICIT
        _proto.time_step_val.CopyFrom(_to_ad_proto(self.time_step))
        if isinstance(self.time_step_ramp, TimeStepRampOff):
            _proto.time_step_ramp = clientpb.TIME_STEP_RAMP_OFF
        if isinstance(self.time_step_ramp, TimeStepRampOn):
            _proto.time_step_ramp = clientpb.TIME_STEP_RAMP_ON
            _proto.time_step_ramp_initial_val.CopyFrom(
                _to_ad_proto(self.time_step_ramp.initial_time_step)
            )
            _proto.time_step_ramp_iteration_begin.value = self.time_step_ramp.start_iteration
            _proto.time_step_ramp_iteration_end.value = self.time_step_ramp.end_iteration
        if isinstance(self.compute_statistics, ComputeStatisticsOff):
            _proto.compute_statistics = clientpb.COMPUTE_STATISTICS_OFF
        if isinstance(self.compute_statistics, ComputeStatisticsOn):
            _proto.compute_statistics = clientpb.COMPUTE_STATISTICS_ON
            _proto.statistics_start_iteration.value = self.compute_statistics.start_iteration
            _proto.statistics_update_interval.value = self.compute_statistics.update_interval
        return _proto

    def _from_proto(self, proto: clientpb.Time) -> None:
        if proto.time_marching == clientpb.INVALID_TIME_MARCHING:
            raise ValueError("Invalid time_marching")
        elif proto.time_marching == clientpb.TIME_IMPLICIT:
            self.time_marching = TimeImplicit()
            self.time_marching.time_implicit_order = enum.TimeImplicitOrder(
                proto.time_implicit_order
            )
        elif proto.time_marching == clientpb.TIME_EXPLICIT:
            self.time_marching = TimeExplicit()
        self.time_step = _from_ad_proto(proto.time_step_val)
        if proto.time_step_ramp == clientpb.INVALID_TIME_STEP_RAMP:
            raise ValueError("Invalid time_step_ramp")
        elif proto.time_step_ramp == clientpb.TIME_STEP_RAMP_OFF:
            self.time_step_ramp = TimeStepRampOff()
        elif proto.time_step_ramp == clientpb.TIME_STEP_RAMP_ON:
            self.time_step_ramp = TimeStepRampOn()
            self.time_step_ramp.initial_time_step = _from_ad_proto(proto.time_step_ramp_initial_val)
            self.time_step_ramp.start_iteration = proto.time_step_ramp_iteration_begin.value
            self.time_step_ramp.end_iteration = proto.time_step_ramp_iteration_end.value
        if proto.compute_statistics == clientpb.INVALID_COMPUTE_STATISTICS:
            raise ValueError("Invalid compute_statistics")
        elif proto.compute_statistics == clientpb.COMPUTE_STATISTICS_OFF:
            self.compute_statistics = ComputeStatisticsOff()
        elif proto.compute_statistics == clientpb.COMPUTE_STATISTICS_ON:
            self.compute_statistics = ComputeStatisticsOn()
            self.compute_statistics.start_iteration = proto.statistics_start_iteration.value
            self.compute_statistics.update_interval = proto.statistics_update_interval.value
        return None
