from external.a79.src.a79.client import A79Client
from external.a79.src.models.tools import DEFAULT
from external.a79.src.models.tools.edgartool_models import (
    GetLatestCompanyFilingTextInput,
    GetLatestCompanyFilingTextOutput,
)

__all__ = [
    "GetLatestCompanyFilingTextInput",
    "GetLatestCompanyFilingTextOutput",
    "get_latest_company_filing_text",
]


def get_latest_company_filing_text(
    *, company_identifier: str, filing_type: str
) -> GetLatestCompanyFilingTextOutput:
    """Get the latest company filing text by company identifier and filing type
    using Edgar API."""
    kwargs = locals()
    kwargs = {k: v for k, v in kwargs.items() if v is not DEFAULT}
    input_model = GetLatestCompanyFilingTextInput.model_validate(kwargs)

    client = A79Client()
    output_model = client.execute_tool(
        package="edgartool",
        name="get_latest_company_filing_text",
        input=input_model.model_dump(),
    )
    return GetLatestCompanyFilingTextOutput.model_validate(output_model)
