# Generated by Django 3.2.11 on 2022-02-03 14:41
import json

from django.db import migrations


def transfer_authors_string_to_authors_json(apps, schema_editor):
    """Convert author names to JSON."""
    Publication = apps.get_model('publication', 'Publication')

    for pub in Publication.objects.all():
        if pub.authors is not None:
            authors_names = [a.strip() for a in pub.authors.split(',')]
        else:
            authors_names = []
        authors = []
        for author_name in authors_names:
            # find last name as last word
            *first_names, last_name = [name_part.strip() for name_part in author_name.split(" ")]

            author_dict = dict(
                first_name=" ".join(first_names),
                last_name=last_name,
                # we leave out orcid_id and affiliations, they're not known here
            )
            authors.append(author_dict)
        pub.authors_json = authors
        pub.save()


def transfer_authors_json_to_authors_string(apps, schema_editor):
    """Convert authors_json to Author names.

    This might cause data loss, because the authors_json potentially
    include more data than just the author's first and last name.
    """
    Publication = apps.get_model('publication', 'Publication')

    for pub in Publication.objects.all():
        # pub.authors_json is assumed to be a json-encoded list of dicts
        pub.authors = ", ".join(f"{author['first_name']} {author['last_name']}" for author in pub.authors_json)
        pub.save()


class Migration(migrations.Migration):

    dependencies = [
        ('publication', '0006_publication_authors_json'),
    ]

    operations = [
        migrations.RunPython(transfer_authors_string_to_authors_json,
                             reverse_code=transfer_authors_json_to_authors_string),
    ]
