# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class OAuthBrowserAuthentication(UniversalBaseModel):
    """
    OAuth authentication via browser flow.

    Supports both OAuth2 and OAuth1 BYOC (Bring Your Own Client):
    - OAuth2 BYOC: Provide client_id + client_secret
    - OAuth1 BYOC: Provide consumer_key + consumer_secret
    """

    redirect_uri: typing.Optional[str] = pydantic.Field(default=None)
    """
    OAuth redirect URI
    """

    client_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    OAuth2 client ID (for custom apps)
    """

    client_secret: typing.Optional[str] = pydantic.Field(default=None)
    """
    OAuth2 client secret (for custom apps)
    """

    consumer_key: typing.Optional[str] = pydantic.Field(default=None)
    """
    OAuth1 consumer key (for custom apps)
    """

    consumer_secret: typing.Optional[str] = pydantic.Field(default=None)
    """
    OAuth1 consumer secret (for custom apps)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
