# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel, update_forward_refs
from .retrieval_strategy import RetrievalStrategy


class SearchRequest(UniversalBaseModel):
    """
    Search request schema.
    """

    query: str = pydantic.Field()
    """
    The search query text
    """

    retrieval_strategy: typing.Optional[RetrievalStrategy] = pydantic.Field(default=None)
    """
    The retrieval strategy to use
    """

    filter: typing.Optional["Filter"] = pydantic.Field(default=None)
    """
    Qdrant native filter for metadata-based filtering
    """

    offset: typing.Optional[int] = pydantic.Field(default=None)
    """
    Number of results to skip
    """

    limit: typing.Optional[int] = pydantic.Field(default=None)
    """
    Maximum number of results to return
    """

    temporal_relevance: typing.Optional[float] = pydantic.Field(default=None)
    """
    Weight recent content higher than older content; 0 = no recency effect, 1 = only recent items matter
    """

    expand_query: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Generate a few query variations to improve recall
    """

    interpret_filters: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Extract structured filters from natural-language query
    """

    rerank: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Reorder the top candidate results for improved relevance. Max number of results that can be reranked is capped to around 1000.
    """

    generate_answer: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Generate a natural-language answer to the query
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


from .filter import Filter  # noqa: E402, F401, I001
from .min_should import MinShould  # noqa: E402, F401, I001
from .nested import Nested  # noqa: E402, F401, I001
from .nested_condition import NestedCondition  # noqa: E402, F401, I001

update_forward_refs(SearchRequest)
