# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class SearchResponse(UniversalBaseModel):
    """
    Comprehensive search response containing results and metadata.
    """

    results: typing.List[typing.Dict[str, typing.Optional[typing.Any]]] = pydantic.Field()
    """
    Array of search result objects containing the found documents, records, or data entities.
    """

    completion: typing.Optional[str] = pydantic.Field(default=None)
    """
    This provides natural language answers to your query based on the content found across your connected data sources when generate_answer is true.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
