# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .fields import Fields


class Source(UniversalBaseModel):
    """
    Complete source representation with authentication and configuration schemas.
    """

    name: str = pydantic.Field()
    """
    Human-readable name of the data source connector (e.g., 'GitHub', 'Stripe', 'PostgreSQL').
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Detailed description explaining what data this source can extract and its typical use cases.
    """

    auth_methods: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of supported authentication methods (e.g., 'direct', 'oauth_browser').
    """

    oauth_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    OAuth token type for OAuth sources (e.g., 'access_only', 'with_refresh').
    """

    requires_byoc: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this OAuth source requires users to bring their own client.
    """

    auth_config_class: typing.Optional[str] = pydantic.Field(default=None)
    """
    Python class name that defines the authentication configuration fields required for this source (only for DIRECT auth).
    """

    config_class: typing.Optional[str] = pydantic.Field(default=None)
    """
    Python class name that defines the source-specific configuration options and parameters.
    """

    short_name: str = pydantic.Field()
    """
    Technical identifier used internally to reference this source type. Must be unique across all sources.
    """

    class_name: str = pydantic.Field()
    """
    Python class name of the source implementation that handles data extraction logic.
    """

    output_entity_definition_ids: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of entity definition IDs that this source can produce. Defines the data schema and structure that this connector outputs.
    """

    labels: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Categorization tags to help users discover and filter sources by domain or use case.
    """

    supports_continuous: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this source supports cursor-based continuous syncing for incremental data extraction. Sources with this capability can track their sync position and resume from where they left off.
    """

    id: str = pydantic.Field()
    """
    Unique system identifier for this source type. Generated automatically when the source is registered.
    """

    created_at: dt.datetime = pydantic.Field()
    """
    Timestamp when this source type was registered in the system (ISO 8601 format).
    """

    modified_at: dt.datetime = pydantic.Field()
    """
    Timestamp when this source type was last updated (ISO 8601 format).
    """

    auth_fields: typing.Optional[Fields] = pydantic.Field(default=None)
    """
    Schema definition for authentication fields required to connect to this source. Only present for sources using DIRECT authentication. OAuth sources handle authentication through browser flows.
    """

    config_fields: Fields = pydantic.Field()
    """
    Schema definition for configuration fields required to customize this source. Describes field types, validation rules, and user interface hints.
    """

    supported_auth_providers: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of auth provider short names that support this source (e.g., ['composio', 'pipedream']). Computed dynamically for API responses. This field is not stored in the database.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
