from enum import Enum


class AmortisationType(Enum):
    """Amortisation Type available when searching bonds."""

    Annuity = "annuity"
    Bullet = "bullet"
    Irregular = "irregular"
    Serial = "serial"


class AssetType(Enum):
    """Asset Type available when searching bonds."""

    BenchmarkBond = "Benchmark Bond"
    DanishCappedFloaters = "Danish Capped Floater"
    CreditBond = "credit bond"
    DanishIndexBond = "Danish index bond"
    DanishMortgageBond = "Danish mortgage bond"
    FixToFloatBond = "Fix To Float Bond"
    FRN = "FRN"
    IndexLinkedBond = "Index Linked Bond"
    NonCallableBond = "Non-callable Bond"


class CapitalCentres(Enum):
    """Capital centres available when searching bonds."""

    BRF_B = "B (BRF)"
    BRF_E = "E (BRF)"
    BRF_General = "GENERAL (BRF)"
    DLR_B = "B (DLR)"
    DLR_General = "GENERAL (DLR)"
    NDA_1 = "1 (NDA)"
    NDA_2 = "2 (NDA)"
    NYK_C = "C (NYK)"
    NYK_D = "D (NYK)"
    NYK_E = "E (NYK)"
    NYK_G = "G (NYK)"
    NYK_General = "GENERAL (NYK)"
    NYK_H = "H (NYK)"
    NYK_I = "I (NYK)"
    RD_General = "GENERAL (RD)"
    RD_S = "S (RD)"
    RD_T = "T (RD)"
    TOT_C = "C (TOT)"


class CapitalCentreTypes(Enum):
    """Capital centre types available when searching bonds."""

    JCB = "JCB"
    RO = "RO"
    SDO = "SDO"
    SDRO = "SDRO"


class Issuers:
    """Most common available issuers. Availability not limit to this list."""

    Aareal_Bank_AG = "Aareal Bank AG"
    Aareal_Beteiligungen_AG = "Aareal Beteiligungen AG"
    Aareal_Hyp_AG = "Aareal Hyp AG"
    ABB_International_Finance_Ltd = "ABB International Finance Ltd"
    Abbey_National_Treasury_Services_London_Plc = (
        "Abbey National Treasury Services (London) Plc"
    )
    Accor_SA = "Accor SA"
    Achmea_Bank_NV = "Achmea Bank NV"
    Adecco_Financial_Service_Ltd = "Adecco Financial Service Ltd"
    Agbar_International_BV = "Agbar International BV"
    ageas_Fin_NV = "ageas Fin NV"
    Ahold_Finance_USA_LLC = "Ahold Finance USA LLC"
    Air_Products_and_Chemicals_Inc = "Air Products and Chemicals Inc"
    Akzo_Nobel_NV = "Akzo Nobel NV"
    Alcatel_Lucent_SA = "Alcatel Lucent SA"
    Allianz_SE = "Allianz SE"
    Allied_Domecq_Financial_Services_Ltd = "Allied Domecq Financial Services Ltd"
    Ally_Financial_Inc = "Ally Financial Inc"
    Altria_Finance_Cayman_Islands_Ltd = "Altria Finance Cayman Islands Ltd"
    Anglian_Water_Services_Financing_Plc = "Anglian Water Services Financing Plc"
    ArcelorMittal_Finance = "ArcelorMittal Finance"
    Asian_Development_Bank = "Asian Development Bank"
    Assa_Abloy_AB = "Assa Abloy AB"
    Assicurazioni_Generali_SpA = "Assicurazioni Generali SpA"
    ATT_Corp = "AT&T Corp"
    Australia = "Australia"
    Australia_and_New_Zealand_Banking_Group_Ltd = (
        "Australia and New Zealand Banking Group Ltd"
    )
    Austria = "Austria"
    Autoliv_Inc_OLD = "Autoliv Inc (OLD)"
    AXA_SA = "AXA SA"
    Banco_Bilbao_Vizcaya_Argentaria_SA = "Banco Bilbao Vizcaya Argentaria SA"
    Banco_Espanol_de_Credito_SA_Banesto = "Banco Español de Crédito SA (Banesto)"
    Bank_1_Oslo_Akershus_AS = "Bank 1 Oslo Akershus AS"
    Bank_fur_Arbeit_und_Wirtschaft_AG = "Bank für Arbeit und Wirtschaft AG"
    Bank_Nederlandse_Gemeenten_NV = "Bank Nederlandse Gemeenten NV"
    Bank_of_America_Corp = "Bank of America Corp"
    Bank_of_Scotland_Plc = "Bank of Scotland Plc"
    Bankinter_SA = "Bankinter SA"
    Barclays_Bank_Plc = "Barclays Bank Plc"
    BASF_SE = "BASF SE"
    BAT_International_Finance_Plc = "BAT International Finance Plc"
    Baxter_International_Inc = "Baxter International Inc"
    Bayer_AG = "Bayer AG"
    Bayerische_Landesbank = "Bayerische Landesbank"
    Belgium = "Belgium"
    Berlin_Hannover_Hypothekenbank_AG = "Berlin-Hannover Hypothekenbank AG"
    Bezeq_Israeli_Telecommunication_Corp_Ltd = (
        "Bezeq Israeli Telecommunication Corp Ltd"
    )
    BMW_Finance_NV = "BMW Finance NV"
    BN_Bank_ASA = "BN Bank ASA"
    Bolig_og_Naeringskreditt_AS = "Bolig og Næringskreditt AS"
    Bombardier_Inc = "Bombardier Inc"
    Bouygues_SA = "Bouygues SA"
    BPB_Ltd = "BPB Ltd"
    BPCE = "BPCE"
    Bradford_and_Bingley_Plc = "Bradford & Bingley Plc"
    Brazil = "Brazil"
    Brisa_Finance_BV = "Brisa Finance BV"
    British_Telecommunications_Plc = "British Telecommunications Plc"
    Burmah_Castrol_Plc = "Burmah Castrol Plc"
    Caisse_Centrale_du_Credit_Immobilier_de_France_SA = (
        "Caisse Centrale du Credit Immobilier de France SA"
    )
    Caisse_dAmortissement_de_la_Dette_Sociale = (
        "Caisse d'Amortissement de la Dette Sociale"
    )
    Caisse_Nationale_des_Autoroutes = "Caisse Nationale des Autoroutes"
    Caixa_d_Estalvis_Catalunya_Tarragona_i_Manresa = (
        "Caixa d Estalvis Catalunya Tarragona i Manresa"
    )
    Caja_de_Ahorros_y_Monte_de_Piedad_de_Madrid = (
        "Caja de Ahorros y Monte de Piedad de Madrid"
    )
    Caja_de_Ahorros_y_Pensiones_de_Barcelona = (
        "Caja de Ahorros y Pensiones de Barcelona"
    )
    Canada = "Canada"
    Carrefour_SA = "Carrefour SA"
    Casino_Guichard_Perrachon_SA = "Casino Guichard Perrachon SA"
    Cie_Financiere_et_Industrielle_des_Autoroutes_SA = (
        "Cie Financiere et Industrielle des Autoroutes SA"
    )
    CIF_Euromortgage_SA = "CIF Euromortgage SA"
    CIFG_Assurn_North_America_Inc = "CIFG Assurn North America Inc"
    CIT_Group_Inc = "CIT Group Inc"
    Citigroup_Inc = "Citigroup Inc"
    Clear_Channel_Communications_Inc = "Clear Channel Communications Inc"
    CocaCola_HBC_Finance_BV = "Coca-Cola HBC Finance BV"
    CocaCola_Refreshments_USA_Inc = "CocaCola Refreshments USA Inc"
    Commerzbank_AG = "Commerzbank AG"
    Compagnie_de_Financement_Foncier_SA = "Compagnie de Financement Foncier SA"
    Compass_Group_Plc = "Compass Group Plc"
    Continental_Rubber_of_America = "Continental Rubber of America"
    Cooper_Industries_Finance_BV = "Cooper Industries Finance BV"
    Corning_Inc = "Corning Inc"
    Corus_Finance_Plc = "Corus Finance Plc"
    Costa_Finance_SA = "Costa Finance SA"
    Croatia = "Croatia"
    Czech_Republic = "Czech Republic"
    Danaher_Corp = "Danaher Corp"
    Danmarks_Skibskreditfond = "Danmarks Skibskreditfond"
    Danone_Finance_SA = "Danone Finance SA"
    Dansk_Landbrugs_Realkreditfond_Kredit_AS = (
        "Dansk Landbrugs Realkreditfond Kredit A/S"
    )
    Danske_Bank_AS = "Danske Bank A/S"
    Danske_Hypotek_AB_Publ = "Danske Hypotek AB (Publ)"
    Danske_Kredit_Realkreditaktieselskab = "Danske Kredit Realkreditaktieselskab"
    DekaBank_Deutsche_Girozentrale = "DekaBank Deutsche Girozentrale"
    Denmark = "Denmark"
    Dentsply_International_Inc = "Dentsply International Inc"
    Deutsche_Bahn_Finance_GmbH = "Deutsche Bahn Finance GmbH"
    Deutsche_Bank_AG = "Deutsche Bank AG"
    Deutsche_Genossenschafts_Hypothekenbank_AG = (
        "Deutsche Genossenschafts-Hypothekenbank AG"
    )
    Deutsche_Hypothekenbank_AG = "Deutsche Hypothekenbank AG"
    Deutsche_Pfandbriefbank_AG = "Deutsche Pfandbriefbank AG"
    Deutsche_Postbank_AG = "Deutsche Postbank AG"
    Deutsche_Telekom_International_Finance_BV = (
        "Deutsche Telekom International Finance BV"
    )
    Development_Bank_of_Japan = "Development Bank of Japan"
    Dexia_Credit_Local_SA = "Dexia Credit Local SA"
    Dexia_Kommunalbank_Deutschland_AG = "Dexia Kommunalbank Deutschland AG"
    Dexia_Municipal_Agency = "Dexia Municipal Agency"
    Dow_Chemical_Co = "Dow Chemical Co"
    Dresdner_Finance_BV = "Dresdner Finance BV"
    Dusseldorfer_Hypothekenbank_AG = "Düsseldorfer Hypothekenbank AG"
    EON_International_Finance_BV = "E.ON International Finance BV"
    EON_UK_Plc = "E.ON UK Plc"
    Ecolab_Inc = "Ecolab Inc"
    Edison_SpA = "Edison SpA"
    EDP_Energias_de_Portugal_SA = "EDP Energias de Portugal SA"
    Eika_Boligkreditt_AS = "Eika Boligkreditt AS"
    El_Paso_Corp = "El Paso Corp"
    Electricite_de_France_SA = "Electricite de France SA"
    Electrolux_AB = "Electrolux AB"
    Elisa_Oyj = "Elisa Oyj"
    EnBW_International_Finance_BV = "EnBW International Finance BV"
    Endesa_SA = "Endesa SA"
    Enel_SpA = "Enel SpA"
    ENI_SpA = "ENI SpA"
    Estonia = "Estonia"
    Euro_Zone = "Euro Zone"
    Eurohypo_AG = "Eurohypo AG"
    Europaische_Hypothekenbank_SA_Luxembourg = (
        "Europäische Hypothekenbank SA Luxembourg"
    )
    European_Investment_Bank = "European Investment Bank"
    EVN_AG = "EVN AG"
    Experian_Finance_Plc = "Experian Finance Plc"
    Fannie_Mae_Federal_National_Mortgage_Association = (
        "Fannie Mae (Federal National Mortgage Association)"
    )
    Faroe_Islands = "Faroe Islands"
    Fiat_Chrysler_Finance_Europe_SA = "Fiat Chrysler Finance Europe SA"
    FIH_Erhvervsbank = "FIH Erhvervsbank"
    FIL_Ltd = "FIL Ltd"
    Finland = "Finland"
    FKI_Ltd = "FKI Ltd"
    Fonterra_Cooperative_Group_Ltd = "Fonterra Cooperative Group Ltd"
    Ford_Motor_Credit_Company_LLC = "Ford Motor Credit Company LLC"
    France = "France"
    France_Telecom_SA = "France Telecom SA"
    Freddie_Mac_Federal_Home_Loan_Mortgage_Corp = (
        "Freddie Mac (Federal Home Loan Mortgage Corp)"
    )
    Gallaher_Group_Ltd = "Gallaher Group Ltd"
    Gas_Natural_Finance_BV = "Gas Natural Finance BV"
    General_Electric_Capital_Corp = "General Electric Capital Corp"
    Germany = "Germany"
    GIE_PSA_Tresorerie = "GIE PSA Tresorerie"
    Gillette_Co = "Gillette Co"
    Goodyear_Tire_and_Rubber_Co = "Goodyear Tire & Rubber Co"
    Greece = "Greece"
    Halifax_Group_Euro_Finance_LP = "Halifax Group Euro Finance LP"
    Hammerson_Plc = "Hammerson Plc"
    HeidelbergCement_Finance_BV = "HeidelbergCement Finance BV"
    Helaba_International_Finance_Plc = "Helaba International Finance Plc"
    Helgeland_Boligkreditt_AS = "Helgeland Boligkreditt AS"
    Hewlett_Packard_Enterprise_Co = "Hewlett Packard Enterprise Co"
    HJ_Heinz_Co = "HJ Heinz Co"
    HSBC_Finance_Corp = "HSBC Finance Corp"
    HSH_N_Finance_Guernsey_Ltd = "HSH N Finance Guernsey Ltd"
    Hungary = "Hungary"
    Hutchison_Whampoa_Finance_CI_Ltd = "Hutchison Whampoa Finance (CI) Ltd"
    Hypo_Alpe_Adria_Bank_International_AG = "Hypo Alpe-Adria-Bank International AG"
    Hypo_Pfandbrief_Bank_International_SA = "Hypo Pfandbrief Bank International SA"
    Hypo_Real_Estate_Bank_AG_Nurnberger_Hypothekenbank = (
        "Hypo Real Estate Bank AG (Nürnberger Hypothekenbank)"
    )
    Hypo_Real_Estate_Bank_International_AG = "Hypo Real Estate Bank International AG"
    Hypo_Tirol_Bank_AG = "Hypo Tirol Bank AG"
    Iberdrola_International_BV = "Iberdrola International BV"
    Imerys_SA = "Imerys SA"
    Imperial_Brands_Finance_Plc = "Imperial Brands Finance Plc"
    ING_Bank_NV = "ING Bank NV"
    ING_Groep_NV = "ING Groep NV"
    Innogy_Finance_BV = "Innogy Finance BV"
    Innogy_Plc = "Innogy Plc"
    Instituto_de_Credito_Oficial = "Instituto de Credito Oficial"
    Inter_American_Development_Bank = "Inter-American Development Bank"
    International_Bank_for_Reconstruction_and_Development = (
        "International Bank for Reconstruction and Development"
    )
    International_Business_Machines_Corp = "International Business Machines Corp"
    International_Lease_Finance_Corp = "International Lease Finance Corp"
    Invensys_Plc = "Invensys Plc"
    Investor_AB = "Investor AB"
    Ireland = "Ireland"
    Italy = "Italy"
    J_Sainsbury_Plc = "J Sainsbury Plc"
    Japan = "Japan"
    JP_Morgan_Chase_and_Co = "JP Morgan Chase & Co"
    Jyske_Realkredit_AS = "Jyske Realkredit A/S"
    KBC_Internationale_Financieringsmaatschappij_NV = (
        "KBC Internationale Financieringsmaatschappij NV"
    )
    Kelda_Group_Ltd = "Kelda Group Ltd"
    Klepierre = "Klepierre"
    Kommunalbanken_AS = "Kommunalbanken AS"
    Kommunekredit_AS = "Kommunekredit AS"
    Kongeriget_Danmarks_Fiskeribank = "Kongeriget Danmarks Fiskeribank"
    Koninklijke_DSM_NV = "Koninklijke DSM NV"
    Koninklijke_KPN_NV = "Koninklijke KPN NV"
    Koninklijke_Philips_NV = "Koninklijke Philips NV"
    Kreditanstalt_fur_Wiederaufbau = "Kreditanstalt für Wiederaufbau"
    Ladbrokes_Group_Finance_Plc = "Ladbrokes Group Finance Plc"
    Lafarge_SA = "Lafarge SA"
    Landesbank_Baden_Wuerttemberg = "Landesbank Baden Wuerttemberg"
    Landesbank_Berlin_AG = "Landesbank Berlin AG"
    Landesbank_Schleswig_Holstein_Girozentrale = (
        "Landesbank Schleswig-Holstein Girozentrale"
    )
    Landmark_Mortgages_Ltd = "Landmark Mortgages Ltd"
    Landshypotek_Bank_AB_publ = "Landshypotek Bank AB (publ)"
    Landwirtschaftliche_Rentenbank = "Landwirtschaftliche Rentenbank"
    Lansforsakringar_Hypotek_AB_publ = "Lansforsakringar Hypotek AB (publ)"
    Latvia = "Latvia"
    Lehman_Brothers_Holdings_Inc = "Lehman Brothers Holdings Inc"
    Linde_Finance_BV = "Linde Finance BV"
    Lithuania = "Lithuania"
    Liz_Claiborne_Inc = "Liz Claiborne Inc"
    LR_Realkredit_Landsbankernes_Reallanefond_AS = (
        "LR Realkredit (Landsbankernes Reallånefond) A/S"
    )
    Marks_and_Spencer_Plc = "Marks & Spencer Plc"
    MBNA_Europe_Funding_Plc = "MBNA Europe Funding Plc"
    McDonalds_Corp = "McDonald's Corp"
    Merrill_Lynch__Inc = "Merrill Lynch  Inc"
    Metallgesellschaft_Finance = "Metallgesellschaft Finance"
    Metro_AG = "Metro AG"
    Metsa_Board_Oyj = "Metsa Board Oyj"
    Metso_Oyj = "Metso Oyj"
    Mexico = "Mexico"
    Michelin_Luxembourg_SCS = "Michelin Luxembourg SCS"
    mmO2_Plc = "mmO2 Plc"
    Morgan_Guaranty_Trust_Co_of_New_York = "Morgan Guaranty Trust Co of New York"
    Morgan_Stanley = "Morgan Stanley"
    Munchener_Hypothekenbank_eG = "Münchener Hypothekenbank eG"
    National_Grid_Gas_Plc = "National Grid Gas Plc"
    National_Rural_Utilities_Cooperative_Finance_Corp = (
        "National Rural Utilities Cooperative Finance Corp"
    )
    Nederlandse_Waterschapsbank_NV = "Nederlandse Waterschapsbank NV"
    Nestle_SA = "Nestle SA"
    Netherlands = "Netherlands"
    New_Zealand = "New Zealand"
    Nippon_Telegraph_and_Telephone_Corp = "Nippon Telegraph & Telephone Corp"
    Norddeutsche_Landesbank_Girozentrale = "Norddeutsche Landesbank Girozentrale"
    Nordea_Nordbanken_Hypotek_AB = "Nordea (Nordbanken) Hypotek AB"
    Nordea_Bank_Abp = "Nordea Bank Abp"
    Nordea_Bank_Danmark_AS = "Nordea Bank Danmark A/S"
    Nordea_Bank_Finland_ABP = "Nordea Bank Finland ABP"
    Nordea_Bank_Norge_ASA = "Nordea Bank Norge ASA"
    Nordea_Bank_Sweden_AB = "Nordea Bank Sweden AB"
    Nordea_Eiendomskreditt_AS = "Nordea Eiendomskreditt AS"
    Nordea_Funds_Oy = "Nordea Funds Oy"
    Nordea_Hypotek_AB = "Nordea Hypotek AB"
    Nordea_Hypoteksbank_Abp = "Nordea Hypoteksbank Abp"
    Nordea_Kredit_Realkreditaktieselskab = "Nordea Kredit Realkreditaktieselskab"
    Nordea_Mortgage_Bank_Plc = "Nordea Mortgage Bank Plc"
    Norsk_Hydro_ASA = "Norsk Hydro ASA"
    Norway = "Norway"
    Novartis_Securities_Investment_Ltd = "Novartis Securities Investment Ltd"
    Nykredit_Realkredit_AS = "Nykredit Realkredit A/S"
    Oesterreichische_Kontrollbank_AG = "Oesterreichische Kontrollbank AG"
    OP_Mortgage_Bank = "OP Mortgage Bank"
    OTE_Plc = "OTE Plc"
    Parker_Hannifin_Corp = "Parker Hannifin Corp"
    Pearson_Funding_Five_Plc = "Pearson Funding Five Plc"
    Pemex_Project_Funding_Master_Trust = "Pemex Project Funding Master Trust"
    Petronas_Capital_Ltd = "Petronas Capital Ltd"
    Pfandbriefstelle_der_Oesterreichischen_Landes_Hypothekenbanken = (
        "Pfandbriefstelle der Oesterreichischen Landes-Hypothekenbanken"
    )
    Pilkington_Group_Ltd = "Pilkington Group Ltd"
    Pirelli_SpA = "Pirelli SpA"
    Poland = "Poland"
    Portugal = "Portugal"
    Portugal_Telecom_International_Finance_BV = (
        "Portugal Telecom International Finance BV"
    )
    PostNL_NV = "PostNL NV"
    Procter_and_Gamble_Co = "Procter & Gamble Co"
    Promodes_SA = "Promodes SA"
    ProSieben_SAT_1_Media_AG = "ProSieben SAT.1 Media AG"
    Public_Power_Corp_SA = "Public Power Corp SA"
    Publishing_and_Broadcasting_Finance_Ltd = "Publishing and Broadcasting Finance Ltd"
    Quebec_Province_of = "Quebec (Province of)"
    Rabobank_Nederland_NV = "Rabobank Nederland NV"
    Realkredit_Danmark_AS = "Realkredit Danmark A/S"
    Reed_Elsevier_Capital_Inc = "Reed Elsevier Capital Inc"
    Renault_SA = "Renault SA"
    Rentokil_Initial_1927_Plc = "Rentokil Initial 1927 Plc"
    Repsol_International_Finance_BV = "Repsol International Finance BV"
    Reseau_Ferre_de_France = "Reseau Ferre de France"
    Residential_Capital_LLC = "Residential Capital LLC"
    Rexam_Plc = "Rexam Plc"
    Rheinland_Pfalz_Bank = "Rheinland-Pfalz Bank"
    Rheinmetall_AG = "Rheinmetall AG"
    Rhodia_SA = "Rhodia SA"
    Rio_Tinto_Finance_Plc = "Rio Tinto Finance Plc"
    Rohm_og_Haas_Denmark_AS = "Rohm & Haas Denmark A/S"
    Rolls_Royce_Plc = "Rolls-Royce Plc"
    Royal_Bank_of_Scotland_NV = "Royal Bank of Scotland NV"
    Russia = "Russia"
    Sachsen_Bank = "Sachsen Bank"
    Saint_Gobain_Nederland_BV = "Saint Gobain Nederland BV"
    Sampo_Housing_Loan_Bank_Plc = "Sampo Housing Loan Bank Plc"
    SANOFI = "SANOFI"
    Santander_UK_Plc = "Santander UK Plc"
    Sara_Lee_Corp = "Sara Lee Corp"
    Scandinavian_Airlines_System_AB = "Scandinavian Airlines System AB"
    Scania_AB = "Scania AB"
    Schlumberger_SA = "Schlumberger SA"
    Schneider_Electric_SE = "Schneider Electric SE"
    SEB_AG = "SEB AG"
    Securitas_AB = "Securitas AB"
    Siemens_Financieringsmaatschappij_NV = "Siemens Financieringsmaatschappij NV"
    Singapore_Telecommunications_Ltd = "Singapore Telecommunications Ltd"
    SingTel_Optus_Finance_Pty_Ltd = "SingTel Optus Finance Pty Ltd"
    Skandinaviska_Enskilda_Banken_BoLan_AB = "Skandinaviska Enskilda Banken BoLån AB"
    Slovakia = "Slovakia"
    Slovenia = "Slovenia"
    SNCF_Mobilites_EPIC = "SNCF Mobilites EPIC"
    SNS_Bank_NV = "SNS Bank NV"
    SODEXO = "SODEXO"
    Sol_Melia_Europe_BV = "Sol Melia Europe BV"
    Solvay_SA = "Solvay SA"
    South_Africa = "South Africa"
    Spain = "Spain"
    Sparebanken_Sor = "Sparebanken Sør"
    Sparebanken_Vest_Boligkreditt_AS = "Sparebanken Vest Boligkreditt AS"
    Sparebankenes_Kredittselskap_AS = "Sparebankenes Kredittselskap A/S"
    Sparkasse_KoelnBonn = "Sparkasse KoelnBonn"
    Stadshypotek_AB = "Stadshypotek AB"
    Stagecoach_Group_Plc = "Stagecoach Group Plc"
    State_of_Saxony_Anhalt = "State of Saxony-Anhalt"
    Statkraft_AS = "Statkraft AS"
    Statoil_ASA = "Statoil ASA"
    Stora_Enso_Oyj = "Stora Enso Oyj"
    Sudzucker_International_Finance_BV = "Südzucker International Finance BV"
    Sveriges_Bostadsfinansieringsaktiebolag = "Sveriges Bostadsfinansieringsaktiebolag"
    Swedbank_Hypotek_AB = "Swedbank Hypotek AB"
    Sweden = "Sweden"
    Swedish_Covered_Bond_Corp = "Swedish Covered Bond Corp"
    Swedish_Match_AB = "Swedish Match AB"
    Switzerland = "Switzerland"
    Syngenta_Luxembourg_Finance_SA = "Syngenta Luxembourg Finance SA"
    TCNZ = "TCNZ"
    TDC_AS = "TDC A/S"
    Technicolor = "Technicolor"
    Telecom_Italia_Finance_Sogerim_SA = "Telecom Italia Finance (Sogerim) SA"
    Telecom_Italia_Finance_SA = "Telecom Italia Finance SA"
    Telefonaktiebolaget_LM_Ericsson = "Telefonaktiebolaget LM Ericsson"
    Telefonica_SA = "Telefonica SA"
    Telenor_ASA = "Telenor ASA"
    Telia_Company_AB = "Telia Company AB"
    TeliaSonera_Finland_Oyj = "TeliaSonera Finland Oyj"
    Telstra_Corporation_Ltd = "Telstra Corporation Ltd"
    Tesco_Plc = "Tesco Plc"
    Textron_Inc = "Textron Inc"
    The_Nielsen_Co = "The Nielsen Co"
    ThyssenKrupp_Finance_Nederland_BV = "ThyssenKrupp Finance Nederland BV"
    TI_Group_Ltd = "TI Group Ltd"
    Tokyo_Electric_Power_Co_Inc = "Tokyo Electric Power Co Inc"
    Total_SA = "Total SA"
    Totalkredit_AS = "Totalkredit A/S"
    Toyota_Motor_Credit_Corp = "Toyota Motor Credit Corp"
    Toys_R_Us_Inc = "Toys R Us Inc"
    TPSA_Eurofinance_BV = "TPSA Eurofinance BV"
    Turkey = "Turkey"
    Tyco_International_Group_SA = "Tyco International Group SA"
    Unibail = "Unibail"
    UniCredit_Bank_AG = "UniCredit Bank AG"
    UniCredit_Bank_Austria_AG = "UniCredit Bank Austria AG"
    Unilever_NV = "Unilever NV"
    United_Kingdom = "United Kingdom"
    United_States = "United States"
    United_Utilities_Water_Plc = "United Utilities Water Plc"
    UPM_Kymmene_Oyj = "UPM-Kymmene Oyj"
    Valeo_SA = "Valeo SA"
    Vattenfall_Treasury_AB = "Vattenfall Treasury AB"
    Vauban_Mobilisation_Garanties_SA = "Vauban Mobilisation Garanties SA"
    Veolia_Environnement = "Veolia Environnement"
    Vodafone_Finance_BV = "Vodafone Finance BV"
    Voith_GmbH = "Voith GmbH"
    Volvo_Treasury_AB = "Volvo Treasury AB"
    Vorarlberger_Landes_und_Hypothekenbank_AG = (
        "Vorarlberger Landes- und Hypothekenbank AG"
    )
    VW_Financial_Services_AG = "VW Financial Services AG"
    Westfaelische_Landschaft_Bodenkreditbank_AG = (
        "Westfaelische Landschaft Bodenkreditbank AG"
    )
    WestLB_AG = "WestLB AG"
    Whirlpool_Corp = "Whirlpool Corp"
    Wolters_Kluwer_NV = "Wolters Kluwer NV"
    WPP_Plc = "WPP Plc"
    Wurth_Finance_International_BV = "Würth Finance International BV"
    Xerox_Corp = "Xerox Corp"
    Yorkshire_Building_Society = "Yorkshire Building Society"
