# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr

from typing import Optional

from edgeimpulse_api.models.classify_job_response import ClassifyJobResponse
from edgeimpulse_api.models.classify_job_response_page import ClassifyJobResponsePage
from edgeimpulse_api.models.classify_sample_for_variants200_response import ClassifySampleForVariants200Response
from edgeimpulse_api.models.classify_sample_response import ClassifySampleResponse
from edgeimpulse_api.models.classify_sample_v2200_response import ClassifySampleV2200Response
from edgeimpulse_api.models.get_sample_response import GetSampleResponse
from edgeimpulse_api.models.keras_model_variant_enum import KerasModelVariantEnum
from edgeimpulse_api.models.test_pretrained_model_response import TestPretrainedModelResponse

from edgeimpulse_api.api_client import ApiClient
from edgeimpulse_api.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ClassifyApi(object):
    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def classify_image(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], image : StrictStr, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs) -> TestPretrainedModelResponse:  # noqa: E501
        """Classify an image

        Test out a trained impulse (using a posted image).

        :param project_id: Project ID (required)
        :type project_id: int
        :param image: (required)
        :type image: str
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TestPretrainedModelResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._classify_image_with_http_info(project_id, image, impulse_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _classify_image_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], image : StrictStr, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs):  # noqa: E501
        """Classify an image 

        Test out a trained impulse (using a posted image).

        :param project_id: Project ID (required)
        :type project_id: int
        :param image: (required)
        :type image: str
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TestPretrainedModelResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'image',
            'impulse_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method classify_image" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('impulse_id') is not None:  # noqa: E501
            _query_params.append(('impulseId', _params['impulse_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}
        if _params['image']:
            _files['image'] = _params['image']

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['multipart/form-data']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "TestPretrainedModelResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/classify/image', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def classify_sample(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], include_debug_info : Annotated[Optional[StrictBool], Field(description="Whether to return the debug information from FOMO classification.")] = None, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs) -> ClassifySampleResponse:  # noqa: E501
        """Classify sample (deprecated)

        This API is deprecated, use classifySampleV2 instead (`/v1/api/{projectId}/classify/v2/{sampleId}`). Classify a complete file against the current impulse. This will move the sliding window (dependent on the sliding window length and the sliding window increase parameters in the impulse) over the complete file, and classify for every window that is extracted.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param include_debug_info: Whether to return the debug information from FOMO classification.
        :type include_debug_info: bool
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ClassifySampleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._classify_sample_with_http_info(project_id, sample_id, include_debug_info, impulse_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _classify_sample_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], include_debug_info : Annotated[Optional[StrictBool], Field(description="Whether to return the debug information from FOMO classification.")] = None, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs):  # noqa: E501
        """Classify sample (deprecated) 

        This API is deprecated, use classifySampleV2 instead (`/v1/api/{projectId}/classify/v2/{sampleId}`). Classify a complete file against the current impulse. This will move the sliding window (dependent on the sliding window length and the sliding window increase parameters in the impulse) over the complete file, and classify for every window that is extracted.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param include_debug_info: Whether to return the debug information from FOMO classification.
        :type include_debug_info: bool
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ClassifySampleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id',
            'include_debug_info',
            'impulse_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method classify_sample" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []
        if _params.get('include_debug_info') is not None:  # noqa: E501
            _query_params.append(('includeDebugInfo', _params['include_debug_info']))
        if _params.get('impulse_id') is not None:  # noqa: E501
            _query_params.append(('impulseId', _params['impulse_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ClassifySampleResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/classify/{sampleId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def classify_sample_by_learn_block(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], block_id : Annotated[StrictInt, Field(..., description="Block ID")], **kwargs) -> ClassifySampleResponse:  # noqa: E501
        """Classify sample by learn block

        This API is deprecated, use classifySampleByLearnBlockV2 (`/v1/api/{projectId}/classify/anomaly-gmm/v2/{blockId}/{sampleId}`) instead. Classify a complete file against the specified learn block. This will move the sliding window (dependent on the sliding window length and the sliding window increase parameters in the impulse) over the complete file, and classify for every window that is extracted.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param block_id: Block ID (required)
        :type block_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ClassifySampleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._classify_sample_by_learn_block_with_http_info(project_id, sample_id, block_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _classify_sample_by_learn_block_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], block_id : Annotated[StrictInt, Field(..., description="Block ID")], **kwargs):  # noqa: E501
        """Classify sample by learn block 

        This API is deprecated, use classifySampleByLearnBlockV2 (`/v1/api/{projectId}/classify/anomaly-gmm/v2/{blockId}/{sampleId}`) instead. Classify a complete file against the specified learn block. This will move the sliding window (dependent on the sliding window length and the sliding window increase parameters in the impulse) over the complete file, and classify for every window that is extracted.

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param block_id: Block ID (required)
        :type block_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ClassifySampleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id',
            'block_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method classify_sample_by_learn_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']
        if _params['block_id']:
            _path_params['blockId'] = _params['block_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ClassifySampleResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/classify/anomaly-gmm/{blockId}/{sampleId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def classify_sample_by_learn_block_v2(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], block_id : Annotated[StrictInt, Field(..., description="Block ID")], variant : Annotated[Optional[KerasModelVariantEnum], Field(description="Keras model variant")] = None, truncate_structured_labels : Annotated[Optional[StrictBool], Field(description="If true, only a slice of labels will be returned for samples with multiple labels.")] = None, **kwargs) -> ClassifySampleV2200Response:  # noqa: E501
        """Classify sample by learn block

        Classify a complete file against the specified learn block. This will move the sliding window (dependent on the sliding window length and the sliding window increase parameters in the impulse) over the complete file, and classify for every window that is extracted. Depending on the size of your file, whether your sample is resampled, and whether the result is cached you'll get either the result or a job back. If you receive a job, then wait for the completion of the job, and then call this function again to receive the results. The unoptimized (float32) model is used by default, and classification with an optimized (int8) model can be slower. 

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param block_id: Block ID (required)
        :type block_id: int
        :param variant: Keras model variant
        :type variant: KerasModelVariantEnum
        :param truncate_structured_labels: If true, only a slice of labels will be returned for samples with multiple labels.
        :type truncate_structured_labels: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ClassifySampleV2200Response
        """
        kwargs['_return_http_data_only'] = True
        return self._classify_sample_by_learn_block_v2_with_http_info(project_id, sample_id, block_id, variant, truncate_structured_labels, **kwargs)  # noqa: E501

    @validate_arguments
    def _classify_sample_by_learn_block_v2_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], block_id : Annotated[StrictInt, Field(..., description="Block ID")], variant : Annotated[Optional[KerasModelVariantEnum], Field(description="Keras model variant")] = None, truncate_structured_labels : Annotated[Optional[StrictBool], Field(description="If true, only a slice of labels will be returned for samples with multiple labels.")] = None, **kwargs):  # noqa: E501
        """Classify sample by learn block 

        Classify a complete file against the specified learn block. This will move the sliding window (dependent on the sliding window length and the sliding window increase parameters in the impulse) over the complete file, and classify for every window that is extracted. Depending on the size of your file, whether your sample is resampled, and whether the result is cached you'll get either the result or a job back. If you receive a job, then wait for the completion of the job, and then call this function again to receive the results. The unoptimized (float32) model is used by default, and classification with an optimized (int8) model can be slower. 

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param block_id: Block ID (required)
        :type block_id: int
        :param variant: Keras model variant
        :type variant: KerasModelVariantEnum
        :param truncate_structured_labels: If true, only a slice of labels will be returned for samples with multiple labels.
        :type truncate_structured_labels: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ClassifySampleV2200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id',
            'block_id',
            'variant',
            'truncate_structured_labels'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method classify_sample_by_learn_block_v2" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']
        if _params['block_id']:
            _path_params['blockId'] = _params['block_id']

        # process the query parameters
        _query_params = []
        if _params.get('variant') is not None:  # noqa: E501
            _query_params.append(('variant', _params['variant']))
        if _params.get('truncate_structured_labels') is not None:  # noqa: E501
            _query_params.append(('truncateStructuredLabels', _params['truncate_structured_labels']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ClassifySampleV2200Response",
        }

        return self.api_client.call_api(
            '/api/{projectId}/classify/anomaly-gmm/v2/{blockId}/{sampleId}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def classify_sample_for_variants(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], variants : Annotated[StrictStr, Field(..., description="List of keras model variants, given as a JSON string")], include_debug_info : Annotated[Optional[StrictBool], Field(description="Whether to return the debug information from FOMO classification.")] = None, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, truncate_structured_labels : Annotated[Optional[StrictBool], Field(description="If true, only a slice of labels will be returned for samples with multiple labels.")] = None, **kwargs) -> ClassifySampleForVariants200Response:  # noqa: E501
        """Classify sample for the given set of variants

        Classify a complete file against the current impulse, for all given variants. Depending on the size of your file and whether the sample is resampled, you may get a job ID in the response. 

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param variants: List of keras model variants, given as a JSON string (required)
        :type variants: str
        :param include_debug_info: Whether to return the debug information from FOMO classification.
        :type include_debug_info: bool
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param truncate_structured_labels: If true, only a slice of labels will be returned for samples with multiple labels.
        :type truncate_structured_labels: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ClassifySampleForVariants200Response
        """
        kwargs['_return_http_data_only'] = True
        return self._classify_sample_for_variants_with_http_info(project_id, sample_id, variants, include_debug_info, impulse_id, truncate_structured_labels, **kwargs)  # noqa: E501

    @validate_arguments
    def _classify_sample_for_variants_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], variants : Annotated[StrictStr, Field(..., description="List of keras model variants, given as a JSON string")], include_debug_info : Annotated[Optional[StrictBool], Field(description="Whether to return the debug information from FOMO classification.")] = None, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, truncate_structured_labels : Annotated[Optional[StrictBool], Field(description="If true, only a slice of labels will be returned for samples with multiple labels.")] = None, **kwargs):  # noqa: E501
        """Classify sample for the given set of variants 

        Classify a complete file against the current impulse, for all given variants. Depending on the size of your file and whether the sample is resampled, you may get a job ID in the response. 

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param variants: List of keras model variants, given as a JSON string (required)
        :type variants: str
        :param include_debug_info: Whether to return the debug information from FOMO classification.
        :type include_debug_info: bool
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param truncate_structured_labels: If true, only a slice of labels will be returned for samples with multiple labels.
        :type truncate_structured_labels: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ClassifySampleForVariants200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id',
            'variants',
            'include_debug_info',
            'impulse_id',
            'truncate_structured_labels'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method classify_sample_for_variants" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []
        if _params.get('include_debug_info') is not None:  # noqa: E501
            _query_params.append(('includeDebugInfo', _params['include_debug_info']))
        if _params.get('variants') is not None:  # noqa: E501
            _query_params.append(('variants', _params['variants']))
        if _params.get('impulse_id') is not None:  # noqa: E501
            _query_params.append(('impulseId', _params['impulse_id']))
        if _params.get('truncate_structured_labels') is not None:  # noqa: E501
            _query_params.append(('truncateStructuredLabels', _params['truncate_structured_labels']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ClassifySampleForVariants200Response",
        }

        return self.api_client.call_api(
            '/api/{projectId}/classify/v2/{sampleId}/variants', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def classify_sample_v2(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], include_debug_info : Annotated[Optional[StrictBool], Field(description="Whether to return the debug information from FOMO classification.")] = None, variant : Annotated[Optional[KerasModelVariantEnum], Field(description="Keras model variant")] = None, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, truncate_structured_labels : Annotated[Optional[StrictBool], Field(description="If true, only a slice of labels will be returned for samples with multiple labels.")] = None, **kwargs) -> ClassifySampleV2200Response:  # noqa: E501
        """Classify sample

        Classify a complete file against the current impulse. This will move the sliding window (dependent on the sliding window length and the sliding window increase parameters in the impulse) over the complete file, and classify for every window that is extracted. Depending on the size of your file, whether your sample is resampled, and whether the result is cached you'll get either the result or a job back. If you receive a job, then wait for the completion of the job, and then call this function again to receive the results. The unoptimized (float32) model is used by default, and classification with an optimized (int8) model can be slower. 

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param include_debug_info: Whether to return the debug information from FOMO classification.
        :type include_debug_info: bool
        :param variant: Keras model variant
        :type variant: KerasModelVariantEnum
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param truncate_structured_labels: If true, only a slice of labels will be returned for samples with multiple labels.
        :type truncate_structured_labels: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ClassifySampleV2200Response
        """
        kwargs['_return_http_data_only'] = True
        return self._classify_sample_v2_with_http_info(project_id, sample_id, include_debug_info, variant, impulse_id, truncate_structured_labels, **kwargs)  # noqa: E501

    @validate_arguments
    def _classify_sample_v2_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], include_debug_info : Annotated[Optional[StrictBool], Field(description="Whether to return the debug information from FOMO classification.")] = None, variant : Annotated[Optional[KerasModelVariantEnum], Field(description="Keras model variant")] = None, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, truncate_structured_labels : Annotated[Optional[StrictBool], Field(description="If true, only a slice of labels will be returned for samples with multiple labels.")] = None, **kwargs):  # noqa: E501
        """Classify sample 

        Classify a complete file against the current impulse. This will move the sliding window (dependent on the sliding window length and the sliding window increase parameters in the impulse) over the complete file, and classify for every window that is extracted. Depending on the size of your file, whether your sample is resampled, and whether the result is cached you'll get either the result or a job back. If you receive a job, then wait for the completion of the job, and then call this function again to receive the results. The unoptimized (float32) model is used by default, and classification with an optimized (int8) model can be slower. 

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param include_debug_info: Whether to return the debug information from FOMO classification.
        :type include_debug_info: bool
        :param variant: Keras model variant
        :type variant: KerasModelVariantEnum
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param truncate_structured_labels: If true, only a slice of labels will be returned for samples with multiple labels.
        :type truncate_structured_labels: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ClassifySampleV2200Response, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id',
            'include_debug_info',
            'variant',
            'impulse_id',
            'truncate_structured_labels'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method classify_sample_v2" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []
        if _params.get('include_debug_info') is not None:  # noqa: E501
            _query_params.append(('includeDebugInfo', _params['include_debug_info']))
        if _params.get('variant') is not None:  # noqa: E501
            _query_params.append(('variant', _params['variant']))
        if _params.get('impulse_id') is not None:  # noqa: E501
            _query_params.append(('impulseId', _params['impulse_id']))
        if _params.get('truncate_structured_labels') is not None:  # noqa: E501
            _query_params.append(('truncateStructuredLabels', _params['truncate_structured_labels']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ClassifySampleV2200Response",
        }

        return self.api_client.call_api(
            '/api/{projectId}/classify/v2/{sampleId}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_classify_job_result(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], feature_explorer_only : Annotated[Optional[StrictBool], Field(description="Whether to get only the classification results relevant to the feature explorer.")] = None, variant : Annotated[Optional[KerasModelVariantEnum], Field(description="Keras model variant")] = None, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, truncate_structured_labels : Annotated[Optional[StrictBool], Field(description="If true, only a slice of labels will be returned for samples with multiple labels.")] = None, **kwargs) -> ClassifyJobResponse:  # noqa: E501
        """Classify job result

        Get classify job result, containing the result for the complete testing dataset.

        :param project_id: Project ID (required)
        :type project_id: int
        :param feature_explorer_only: Whether to get only the classification results relevant to the feature explorer.
        :type feature_explorer_only: bool
        :param variant: Keras model variant
        :type variant: KerasModelVariantEnum
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param truncate_structured_labels: If true, only a slice of labels will be returned for samples with multiple labels.
        :type truncate_structured_labels: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ClassifyJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_classify_job_result_with_http_info(project_id, feature_explorer_only, variant, impulse_id, truncate_structured_labels, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_classify_job_result_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], feature_explorer_only : Annotated[Optional[StrictBool], Field(description="Whether to get only the classification results relevant to the feature explorer.")] = None, variant : Annotated[Optional[KerasModelVariantEnum], Field(description="Keras model variant")] = None, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, truncate_structured_labels : Annotated[Optional[StrictBool], Field(description="If true, only a slice of labels will be returned for samples with multiple labels.")] = None, **kwargs):  # noqa: E501
        """Classify job result 

        Get classify job result, containing the result for the complete testing dataset.

        :param project_id: Project ID (required)
        :type project_id: int
        :param feature_explorer_only: Whether to get only the classification results relevant to the feature explorer.
        :type feature_explorer_only: bool
        :param variant: Keras model variant
        :type variant: KerasModelVariantEnum
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param truncate_structured_labels: If true, only a slice of labels will be returned for samples with multiple labels.
        :type truncate_structured_labels: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ClassifyJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'feature_explorer_only',
            'variant',
            'impulse_id',
            'truncate_structured_labels'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_classify_job_result" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('feature_explorer_only') is not None:  # noqa: E501
            _query_params.append(('featureExplorerOnly', _params['feature_explorer_only']))
        if _params.get('variant') is not None:  # noqa: E501
            _query_params.append(('variant', _params['variant']))
        if _params.get('impulse_id') is not None:  # noqa: E501
            _query_params.append(('impulseId', _params['impulse_id']))
        if _params.get('truncate_structured_labels') is not None:  # noqa: E501
            _query_params.append(('truncateStructuredLabels', _params['truncate_structured_labels']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ClassifyJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/classify/all/result', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_classify_job_result_page(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.")] = None, variant : Annotated[Optional[KerasModelVariantEnum], Field(description="Keras model variant")] = None, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, truncate_structured_labels : Annotated[Optional[StrictBool], Field(description="If true, only a slice of labels will be returned for samples with multiple labels.")] = None, **kwargs) -> ClassifyJobResponsePage:  # noqa: E501
        """Single page of a classify job result

        Get classify job result, containing the predictions for a given page.

        :param project_id: Project ID (required)
        :type project_id: int
        :param limit: Maximum number of results
        :type limit: int
        :param offset: Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.
        :type offset: int
        :param variant: Keras model variant
        :type variant: KerasModelVariantEnum
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param truncate_structured_labels: If true, only a slice of labels will be returned for samples with multiple labels.
        :type truncate_structured_labels: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ClassifyJobResponsePage
        """
        kwargs['_return_http_data_only'] = True
        return self._get_classify_job_result_page_with_http_info(project_id, limit, offset, variant, impulse_id, truncate_structured_labels, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_classify_job_result_page_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], limit : Annotated[Optional[StrictInt], Field(description="Maximum number of results")] = None, offset : Annotated[Optional[StrictInt], Field(description="Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.")] = None, variant : Annotated[Optional[KerasModelVariantEnum], Field(description="Keras model variant")] = None, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, truncate_structured_labels : Annotated[Optional[StrictBool], Field(description="If true, only a slice of labels will be returned for samples with multiple labels.")] = None, **kwargs):  # noqa: E501
        """Single page of a classify job result 

        Get classify job result, containing the predictions for a given page.

        :param project_id: Project ID (required)
        :type project_id: int
        :param limit: Maximum number of results
        :type limit: int
        :param offset: Offset in results, can be used in conjunction with LimitResultsParameter to implement paging.
        :type offset: int
        :param variant: Keras model variant
        :type variant: KerasModelVariantEnum
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param truncate_structured_labels: If true, only a slice of labels will be returned for samples with multiple labels.
        :type truncate_structured_labels: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ClassifyJobResponsePage, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'limit',
            'offset',
            'variant',
            'impulse_id',
            'truncate_structured_labels'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_classify_job_result_page" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('offset') is not None:  # noqa: E501
            _query_params.append(('offset', _params['offset']))
        if _params.get('variant') is not None:  # noqa: E501
            _query_params.append(('variant', _params['variant']))
        if _params.get('impulse_id') is not None:  # noqa: E501
            _query_params.append(('impulseId', _params['impulse_id']))
        if _params.get('truncate_structured_labels') is not None:  # noqa: E501
            _query_params.append(('truncateStructuredLabels', _params['truncate_structured_labels']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "ClassifyJobResponsePage",
        }

        return self.api_client.call_api(
            '/api/{projectId}/classify/all/result/page', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_sample_window_from_cache(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], window_index : Annotated[StrictInt, Field(..., description="Sample window index")], impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, truncate_structured_labels : Annotated[Optional[StrictBool], Field(description="If true, only a slice of labels will be returned for samples with multiple labels.")] = None, **kwargs) -> GetSampleResponse:  # noqa: E501
        """Get a window of raw sample features from cache, after a live classification job has completed.

        Get raw sample features for a particular window. This is only available after a live classification job has completed and raw features have been cached. 

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param window_index: Sample window index (required)
        :type window_index: int
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param truncate_structured_labels: If true, only a slice of labels will be returned for samples with multiple labels.
        :type truncate_structured_labels: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetSampleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_sample_window_from_cache_with_http_info(project_id, sample_id, window_index, impulse_id, truncate_structured_labels, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_sample_window_from_cache_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], window_index : Annotated[StrictInt, Field(..., description="Sample window index")], impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, truncate_structured_labels : Annotated[Optional[StrictBool], Field(description="If true, only a slice of labels will be returned for samples with multiple labels.")] = None, **kwargs):  # noqa: E501
        """Get a window of raw sample features from cache, after a live classification job has completed. 

        Get raw sample features for a particular window. This is only available after a live classification job has completed and raw features have been cached. 

        :param project_id: Project ID (required)
        :type project_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param window_index: Sample window index (required)
        :type window_index: int
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param truncate_structured_labels: If true, only a slice of labels will be returned for samples with multiple labels.
        :type truncate_structured_labels: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetSampleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'sample_id',
            'window_index',
            'impulse_id',
            'truncate_structured_labels'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sample_window_from_cache" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']
        if _params['window_index']:
            _path_params['windowIndex'] = _params['window_index']

        # process the query parameters
        _query_params = []
        if _params.get('impulse_id') is not None:  # noqa: E501
            _query_params.append(('impulseId', _params['impulse_id']))
        if _params.get('truncate_structured_labels') is not None:  # noqa: E501
            _query_params.append(('truncateStructuredLabels', _params['truncate_structured_labels']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetSampleResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/classify/v2/{sampleId}/raw-data/{windowIndex}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
