# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr

from typing import Optional

from edgeimpulse_api.models.dsp_config_request import DSPConfigRequest
from edgeimpulse_api.models.dsp_config_response import DSPConfigResponse
from edgeimpulse_api.models.dsp_metadata_response import DSPMetadataResponse
from edgeimpulse_api.models.dsp_autotuner_results import DspAutotunerResults
from edgeimpulse_api.models.dsp_feature_importance_response import DspFeatureImportanceResponse
from edgeimpulse_api.models.dsp_feature_labels_response import DspFeatureLabelsResponse
from edgeimpulse_api.models.dsp_performance_all_variants_response import DspPerformanceAllVariantsResponse
from edgeimpulse_api.models.dsp_run_request_with_features import DspRunRequestWithFeatures
from edgeimpulse_api.models.dsp_run_request_without_features import DspRunRequestWithoutFeatures
from edgeimpulse_api.models.dsp_run_request_without_features_read_only import DspRunRequestWithoutFeaturesReadOnly
from edgeimpulse_api.models.dsp_run_response import DspRunResponse
from edgeimpulse_api.models.dsp_run_response_with_sample import DspRunResponseWithSample
from edgeimpulse_api.models.dsp_sample_features_response import DspSampleFeaturesResponse
from edgeimpulse_api.models.dsp_trained_features_response import DspTrainedFeaturesResponse
from edgeimpulse_api.models.generic_api_response import GenericApiResponse
from edgeimpulse_api.models.get_sample_response import GetSampleResponse
from edgeimpulse_api.models.raw_data_category import RawDataCategory
from edgeimpulse_api.models.start_job_response import StartJobResponse

from edgeimpulse_api.api_client import ApiClient
from edgeimpulse_api.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class DSPApi(object):
    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def clear_dsp_block(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], **kwargs) -> GenericApiResponse:  # noqa: E501
        """Clear DSP block

        Clear generated features for a DSP block (used in tests).

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._clear_dsp_block_with_http_info(project_id, dsp_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _clear_dsp_block_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], **kwargs):  # noqa: E501
        """Clear DSP block 

        Clear generated features for a DSP block (used in tests).

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'dsp_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method clear_dsp_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/dsp/{dspId}/clear', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def download_dsp_data(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], category : Annotated[RawDataCategory, Field(..., description="Which of the three acquisition categories to download data from")], raw : Annotated[Optional[StrictBool], Field(description="Whether to download raw data or processed data. Processed data is the default.")] = None, **kwargs) -> str:  # noqa: E501
        """Download DSP data

        Download output from a DSP block over all data in the training set, already sliced in windows. In Numpy binary format.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param category: Which of the three acquisition categories to download data from (required)
        :type category: RawDataCategory
        :param raw: Whether to download raw data or processed data. Processed data is the default.
        :type raw: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self._download_dsp_data_with_http_info(project_id, dsp_id, category, raw, **kwargs)  # noqa: E501

    @validate_arguments
    def _download_dsp_data_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], category : Annotated[RawDataCategory, Field(..., description="Which of the three acquisition categories to download data from")], raw : Annotated[Optional[StrictBool], Field(description="Whether to download raw data or processed data. Processed data is the default.")] = None, **kwargs):  # noqa: E501
        """Download DSP data 

        Download output from a DSP block over all data in the training set, already sliced in windows. In Numpy binary format.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param category: Which of the three acquisition categories to download data from (required)
        :type category: RawDataCategory
        :param raw: Whether to download raw data or processed data. Processed data is the default.
        :type raw: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'dsp_id',
            'category',
            'raw'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_dsp_data" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']
        if _params['category']:
            _path_params['category'] = _params['category']

        # process the query parameters
        _query_params = []
        if _params.get('raw') is not None:  # noqa: E501
            _query_params.append(('raw', _params['raw']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "str",
        }

        return self.api_client.call_api(
            '/api/{projectId}/dsp-data/{dspId}/x/{category}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def download_dsp_labels(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], category : Annotated[RawDataCategory, Field(..., description="Which of the three acquisition categories to download data from")], **kwargs) -> str:  # noqa: E501
        """Download DSP labels

        Download labels for a DSP block over all data in the training set, already sliced in windows.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param category: Which of the three acquisition categories to download data from (required)
        :type category: RawDataCategory
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self._download_dsp_labels_with_http_info(project_id, dsp_id, category, **kwargs)  # noqa: E501

    @validate_arguments
    def _download_dsp_labels_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], category : Annotated[RawDataCategory, Field(..., description="Which of the three acquisition categories to download data from")], **kwargs):  # noqa: E501
        """Download DSP labels 

        Download labels for a DSP block over all data in the training set, already sliced in windows.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param category: Which of the three acquisition categories to download data from (required)
        :type category: RawDataCategory
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'dsp_id',
            'category'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_dsp_labels" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']
        if _params['category']:
            _path_params['category'] = _params['category']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "str",
        }

        return self.api_client.call_api(
            '/api/{projectId}/dsp-data/{dspId}/y/{category}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def dsp_get_features_for_sample(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], **kwargs) -> DspSampleFeaturesResponse:  # noqa: E501
        """Features for sample

        Runs the DSP block against a sample. This will move the sliding window (dependent on the sliding window length and the sliding window increase parameters in the impulse) over the complete file, and run the DSP function for every window that is extracted.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DspSampleFeaturesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._dsp_get_features_for_sample_with_http_info(project_id, dsp_id, sample_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _dsp_get_features_for_sample_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], **kwargs):  # noqa: E501
        """Features for sample 

        Runs the DSP block against a sample. This will move the sliding window (dependent on the sliding window length and the sliding window increase parameters in the impulse) over the complete file, and run the DSP function for every window that is extracted.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DspSampleFeaturesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'dsp_id',
            'sample_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method dsp_get_features_for_sample" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "DspSampleFeaturesResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/dsp/{dspId}/features/get-graph/classification/{sampleId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def dsp_sample_trained_features(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], feature_ax1 : Annotated[StrictInt, Field(..., description="Feature axis 1")], feature_ax2 : Annotated[StrictInt, Field(..., description="Feature axis 2")], feature_ax3 : Annotated[StrictInt, Field(..., description="Feature axis 3")], category : Annotated[RawDataCategory, Field(..., description="Which of the three acquisition categories to download data from")], **kwargs) -> DspTrainedFeaturesResponse:  # noqa: E501
        """Sample of trained features

        Get a sample of trained features, this extracts a number of samples and their labels. Used to visualize the current training set.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param feature_ax1: Feature axis 1 (required)
        :type feature_ax1: int
        :param feature_ax2: Feature axis 2 (required)
        :type feature_ax2: int
        :param feature_ax3: Feature axis 3 (required)
        :type feature_ax3: int
        :param category: Which of the three acquisition categories to download data from (required)
        :type category: RawDataCategory
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DspTrainedFeaturesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._dsp_sample_trained_features_with_http_info(project_id, dsp_id, feature_ax1, feature_ax2, feature_ax3, category, **kwargs)  # noqa: E501

    @validate_arguments
    def _dsp_sample_trained_features_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], feature_ax1 : Annotated[StrictInt, Field(..., description="Feature axis 1")], feature_ax2 : Annotated[StrictInt, Field(..., description="Feature axis 2")], feature_ax3 : Annotated[StrictInt, Field(..., description="Feature axis 3")], category : Annotated[RawDataCategory, Field(..., description="Which of the three acquisition categories to download data from")], **kwargs):  # noqa: E501
        """Sample of trained features 

        Get a sample of trained features, this extracts a number of samples and their labels. Used to visualize the current training set.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param feature_ax1: Feature axis 1 (required)
        :type feature_ax1: int
        :param feature_ax2: Feature axis 2 (required)
        :type feature_ax2: int
        :param feature_ax3: Feature axis 3 (required)
        :type feature_ax3: int
        :param category: Which of the three acquisition categories to download data from (required)
        :type category: RawDataCategory
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DspTrainedFeaturesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'dsp_id',
            'feature_ax1',
            'feature_ax2',
            'feature_ax3',
            'category'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method dsp_sample_trained_features" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']
        if _params['category']:
            _path_params['category'] = _params['category']

        # process the query parameters
        _query_params = []
        if _params.get('feature_ax1') is not None:  # noqa: E501
            _query_params.append(('featureAx1', _params['feature_ax1']))
        if _params.get('feature_ax2') is not None:  # noqa: E501
            _query_params.append(('featureAx2', _params['feature_ax2']))
        if _params.get('feature_ax3') is not None:  # noqa: E501
            _query_params.append(('featureAx3', _params['feature_ax3']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "DspTrainedFeaturesResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/dsp/{dspId}/features/get-graph/{category}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_autotuner_results(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], **kwargs) -> DspAutotunerResults:  # noqa: E501
        """Get results from DSP autotuner

        Get a set of parameters, found as a result of running the DSP autotuner.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DspAutotunerResults
        """
        kwargs['_return_http_data_only'] = True
        return self._get_autotuner_results_with_http_info(project_id, dsp_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_autotuner_results_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], **kwargs):  # noqa: E501
        """Get results from DSP autotuner 

        Get a set of parameters, found as a result of running the DSP autotuner.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DspAutotunerResults, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'dsp_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_autotuner_results" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "DspAutotunerResults",
        }

        return self.api_client.call_api(
            '/api/{projectId}/dsp/{dspId}/get-autotuner-results', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_dsp_config(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], **kwargs) -> DSPConfigResponse:  # noqa: E501
        """Get config

        Retrieve the configuration parameters for the DSP block. Use the impulse functions to retrieve all DSP blocks.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DSPConfigResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_dsp_config_with_http_info(project_id, dsp_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_dsp_config_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], **kwargs):  # noqa: E501
        """Get config 

        Retrieve the configuration parameters for the DSP block. Use the impulse functions to retrieve all DSP blocks.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DSPConfigResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'dsp_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dsp_config" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "DSPConfigResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/dsp/{dspId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_dsp_feature_importance(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], **kwargs) -> DspFeatureImportanceResponse:  # noqa: E501
        """Feature importance

        Retrieve the feature importance for a DSP block (only available for blocks where dimensionalityReduction is not enabled)

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DspFeatureImportanceResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_dsp_feature_importance_with_http_info(project_id, dsp_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_dsp_feature_importance_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], **kwargs):  # noqa: E501
        """Feature importance 

        Retrieve the feature importance for a DSP block (only available for blocks where dimensionalityReduction is not enabled)

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DspFeatureImportanceResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'dsp_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dsp_feature_importance" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "DspFeatureImportanceResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/dsp/{dspId}/features/importance', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_dsp_feature_labels(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], **kwargs) -> DspFeatureLabelsResponse:  # noqa: E501
        """Feature labels

        Retrieve the names of the features the DSP block generates

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DspFeatureLabelsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_dsp_feature_labels_with_http_info(project_id, dsp_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_dsp_feature_labels_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], **kwargs):  # noqa: E501
        """Feature labels 

        Retrieve the names of the features the DSP block generates

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DspFeatureLabelsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'dsp_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dsp_feature_labels" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "DspFeatureLabelsResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/dsp/{dspId}/features/labels', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_dsp_metadata(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], exclude_included_samples : Annotated[Optional[StrictBool], Field(description="Whether to exclude 'includedSamples' in the response (as these can slow down requests significantly).")] = None, category : Annotated[Optional[StrictStr], Field(description="Which of the acquisition categories to get metadata from")] = None, **kwargs) -> DSPMetadataResponse:  # noqa: E501
        """Get metadata

        Retrieve the metadata from a generated DSP block.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param exclude_included_samples: Whether to exclude 'includedSamples' in the response (as these can slow down requests significantly).
        :type exclude_included_samples: bool
        :param category: Which of the acquisition categories to get metadata from
        :type category: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DSPMetadataResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_dsp_metadata_with_http_info(project_id, dsp_id, exclude_included_samples, category, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_dsp_metadata_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], exclude_included_samples : Annotated[Optional[StrictBool], Field(description="Whether to exclude 'includedSamples' in the response (as these can slow down requests significantly).")] = None, category : Annotated[Optional[StrictStr], Field(description="Which of the acquisition categories to get metadata from")] = None, **kwargs):  # noqa: E501
        """Get metadata 

        Retrieve the metadata from a generated DSP block.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param exclude_included_samples: Whether to exclude 'includedSamples' in the response (as these can slow down requests significantly).
        :type exclude_included_samples: bool
        :param category: Which of the acquisition categories to get metadata from
        :type category: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DSPMetadataResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'dsp_id',
            'exclude_included_samples',
            'category'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dsp_metadata" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']

        # process the query parameters
        _query_params = []
        if _params.get('exclude_included_samples') is not None:  # noqa: E501
            _query_params.append(('excludeIncludedSamples', _params['exclude_included_samples']))
        if _params.get('category') is not None:  # noqa: E501
            _query_params.append(('category', _params['category']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "DSPMetadataResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/dsp/{dspId}/metadata', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_dsp_raw_sample(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], limit_payload_values : Annotated[Optional[StrictInt], Field(description="Limit the number of payload values in the response")] = None, truncate_structured_labels : Annotated[Optional[StrictBool], Field(description="If true, only a slice of labels will be returned for samples with multiple labels.")] = None, **kwargs) -> GetSampleResponse:  # noqa: E501
        """Get raw sample

        Get raw sample data, but with only the axes selected by the DSP block. E.g. if you have selected only accX and accY as inputs for the DSP block, but the raw sample also contains accZ, accZ is filtered out. If you pass dspId = 0 this will return a raw graph without any processing.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param limit_payload_values: Limit the number of payload values in the response
        :type limit_payload_values: int
        :param truncate_structured_labels: If true, only a slice of labels will be returned for samples with multiple labels.
        :type truncate_structured_labels: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetSampleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_dsp_raw_sample_with_http_info(project_id, dsp_id, sample_id, limit_payload_values, truncate_structured_labels, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_dsp_raw_sample_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], limit_payload_values : Annotated[Optional[StrictInt], Field(description="Limit the number of payload values in the response")] = None, truncate_structured_labels : Annotated[Optional[StrictBool], Field(description="If true, only a slice of labels will be returned for samples with multiple labels.")] = None, **kwargs):  # noqa: E501
        """Get raw sample 

        Get raw sample data, but with only the axes selected by the DSP block. E.g. if you have selected only accX and accY as inputs for the DSP block, but the raw sample also contains accZ, accZ is filtered out. If you pass dspId = 0 this will return a raw graph without any processing.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param limit_payload_values: Limit the number of payload values in the response
        :type limit_payload_values: int
        :param truncate_structured_labels: If true, only a slice of labels will be returned for samples with multiple labels.
        :type truncate_structured_labels: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetSampleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'dsp_id',
            'sample_id',
            'limit_payload_values',
            'truncate_structured_labels'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dsp_raw_sample" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []
        if _params.get('limit_payload_values') is not None:  # noqa: E501
            _query_params.append(('limitPayloadValues', _params['limit_payload_values']))
        if _params.get('truncate_structured_labels') is not None:  # noqa: E501
            _query_params.append(('truncateStructuredLabels', _params['truncate_structured_labels']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetSampleResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/dsp/{dspId}/raw-data/{sampleId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_dsp_sample_slice(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], slice_start : Annotated[StrictInt, Field(..., description="Begin index of the slice")], slice_end : Annotated[Optional[StrictInt], Field(description="End index of the slice. If not given, the sample will be sliced to the same length as the impulse input block window length.")] = None, truncate_structured_labels : Annotated[Optional[StrictBool], Field(description="If true, only a slice of labels will be returned for samples with multiple labels.")] = None, **kwargs) -> GetSampleResponse:  # noqa: E501
        """Get raw sample (slice)

        Get slice of raw sample data, but with only the axes selected by the DSP block. E.g. if you have selected only accX and accY as inputs for the DSP block, but the raw sample also contains accZ, accZ is filtered out.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param slice_start: Begin index of the slice (required)
        :type slice_start: int
        :param slice_end: End index of the slice. If not given, the sample will be sliced to the same length as the impulse input block window length.
        :type slice_end: int
        :param truncate_structured_labels: If true, only a slice of labels will be returned for samples with multiple labels.
        :type truncate_structured_labels: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetSampleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_dsp_sample_slice_with_http_info(project_id, dsp_id, sample_id, slice_start, slice_end, truncate_structured_labels, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_dsp_sample_slice_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], slice_start : Annotated[StrictInt, Field(..., description="Begin index of the slice")], slice_end : Annotated[Optional[StrictInt], Field(description="End index of the slice. If not given, the sample will be sliced to the same length as the impulse input block window length.")] = None, truncate_structured_labels : Annotated[Optional[StrictBool], Field(description="If true, only a slice of labels will be returned for samples with multiple labels.")] = None, **kwargs):  # noqa: E501
        """Get raw sample (slice) 

        Get slice of raw sample data, but with only the axes selected by the DSP block. E.g. if you have selected only accX and accY as inputs for the DSP block, but the raw sample also contains accZ, accZ is filtered out.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param slice_start: Begin index of the slice (required)
        :type slice_start: int
        :param slice_end: End index of the slice. If not given, the sample will be sliced to the same length as the impulse input block window length.
        :type slice_end: int
        :param truncate_structured_labels: If true, only a slice of labels will be returned for samples with multiple labels.
        :type truncate_structured_labels: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetSampleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'dsp_id',
            'sample_id',
            'slice_start',
            'slice_end',
            'truncate_structured_labels'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_dsp_sample_slice" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []
        if _params.get('slice_start') is not None:  # noqa: E501
            _query_params.append(('sliceStart', _params['slice_start']))
        if _params.get('slice_end') is not None:  # noqa: E501
            _query_params.append(('sliceEnd', _params['slice_end']))
        if _params.get('truncate_structured_labels') is not None:  # noqa: E501
            _query_params.append(('truncateStructuredLabels', _params['truncate_structured_labels']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetSampleResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/dsp/{dspId}/raw-data/{sampleId}/slice', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_performance_all_variants(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], **kwargs) -> DspPerformanceAllVariantsResponse:  # noqa: E501
        """Get DSP block performance for all latency devices

        Get estimated performance (latency and RAM) for the DSP block, for all supported project latency devices.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DspPerformanceAllVariantsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_performance_all_variants_with_http_info(project_id, dsp_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_performance_all_variants_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], **kwargs):  # noqa: E501
        """Get DSP block performance for all latency devices 

        Get estimated performance (latency and RAM) for the DSP block, for all supported project latency devices.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DspPerformanceAllVariantsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'dsp_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_performance_all_variants" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "DspPerformanceAllVariantsResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/dsp/{dspId}/performance', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def run_dsp_on_features_array(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], dsp_run_request_with_features : DspRunRequestWithFeatures, **kwargs) -> DspRunResponse:  # noqa: E501
        """Get processed sample (from features array)

        Takes in a features array and runs it through the DSP block. This data should have the same frequency as set in the input block in your impulse.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param dsp_run_request_with_features: (required)
        :type dsp_run_request_with_features: DspRunRequestWithFeatures
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DspRunResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._run_dsp_on_features_array_with_http_info(project_id, dsp_id, dsp_run_request_with_features, **kwargs)  # noqa: E501

    @validate_arguments
    def _run_dsp_on_features_array_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], dsp_run_request_with_features : DspRunRequestWithFeatures, **kwargs):  # noqa: E501
        """Get processed sample (from features array) 

        Takes in a features array and runs it through the DSP block. This data should have the same frequency as set in the input block in your impulse.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param dsp_run_request_with_features: (required)
        :type dsp_run_request_with_features: DspRunRequestWithFeatures
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DspRunResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'dsp_id',
            'dsp_run_request_with_features'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_dsp_on_features_array" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['dsp_run_request_with_features']:
            _body_params = _params['dsp_run_request_with_features']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "DspRunResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/dsp/{dspId}/run', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def run_dsp_sample_slice(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], slice_start : Annotated[StrictInt, Field(..., description="Begin index of the slice")], dsp_run_request_without_features : DspRunRequestWithoutFeatures, slice_end : Annotated[Optional[StrictInt], Field(description="End index of the slice. If not given, the sample will be sliced to the same length as the impulse input block window length.")] = None, **kwargs) -> DspRunResponseWithSample:  # noqa: E501
        """Get processed sample (slice)

        Get slice of sample data, and run it through the DSP block. This only the axes selected by the DSP block. E.g. if you have selected only accX and accY as inputs for the DSP block, but the raw sample also contains accZ, accZ is filtered out.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param slice_start: Begin index of the slice (required)
        :type slice_start: int
        :param dsp_run_request_without_features: (required)
        :type dsp_run_request_without_features: DspRunRequestWithoutFeatures
        :param slice_end: End index of the slice. If not given, the sample will be sliced to the same length as the impulse input block window length.
        :type slice_end: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DspRunResponseWithSample
        """
        kwargs['_return_http_data_only'] = True
        return self._run_dsp_sample_slice_with_http_info(project_id, dsp_id, sample_id, slice_start, dsp_run_request_without_features, slice_end, **kwargs)  # noqa: E501

    @validate_arguments
    def _run_dsp_sample_slice_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], slice_start : Annotated[StrictInt, Field(..., description="Begin index of the slice")], dsp_run_request_without_features : DspRunRequestWithoutFeatures, slice_end : Annotated[Optional[StrictInt], Field(description="End index of the slice. If not given, the sample will be sliced to the same length as the impulse input block window length.")] = None, **kwargs):  # noqa: E501
        """Get processed sample (slice) 

        Get slice of sample data, and run it through the DSP block. This only the axes selected by the DSP block. E.g. if you have selected only accX and accY as inputs for the DSP block, but the raw sample also contains accZ, accZ is filtered out.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param slice_start: Begin index of the slice (required)
        :type slice_start: int
        :param dsp_run_request_without_features: (required)
        :type dsp_run_request_without_features: DspRunRequestWithoutFeatures
        :param slice_end: End index of the slice. If not given, the sample will be sliced to the same length as the impulse input block window length.
        :type slice_end: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DspRunResponseWithSample, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'dsp_id',
            'sample_id',
            'slice_start',
            'dsp_run_request_without_features',
            'slice_end'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_dsp_sample_slice" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []
        if _params.get('slice_start') is not None:  # noqa: E501
            _query_params.append(('sliceStart', _params['slice_start']))
        if _params.get('slice_end') is not None:  # noqa: E501
            _query_params.append(('sliceEnd', _params['slice_end']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['dsp_run_request_without_features']:
            _body_params = _params['dsp_run_request_without_features']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "DspRunResponseWithSample",
        }

        return self.api_client.call_api(
            '/api/{projectId}/dsp/{dspId}/raw-data/{sampleId}/slice/run', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def run_dsp_sample_slice_read_only(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], slice_start : Annotated[StrictInt, Field(..., description="Begin index of the slice")], slice_end : Annotated[Optional[StrictInt], Field(description="End index of the slice. If not given, the sample will be sliced to the same length as the impulse input block window length.")] = None, **kwargs) -> DspRunResponseWithSample:  # noqa: E501
        """Get processed sample (slice)

        Get slice of sample data, and run it through the DSP block. This only the axes selected by the DSP block. E.g. if you have selected only accX and accY as inputs for the DSP block, but the raw sample also contains accZ, accZ is filtered out.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param slice_start: Begin index of the slice (required)
        :type slice_start: int
        :param slice_end: End index of the slice. If not given, the sample will be sliced to the same length as the impulse input block window length.
        :type slice_end: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DspRunResponseWithSample
        """
        kwargs['_return_http_data_only'] = True
        return self._run_dsp_sample_slice_read_only_with_http_info(project_id, dsp_id, sample_id, slice_start, slice_end, **kwargs)  # noqa: E501

    @validate_arguments
    def _run_dsp_sample_slice_read_only_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], slice_start : Annotated[StrictInt, Field(..., description="Begin index of the slice")], slice_end : Annotated[Optional[StrictInt], Field(description="End index of the slice. If not given, the sample will be sliced to the same length as the impulse input block window length.")] = None, **kwargs):  # noqa: E501
        """Get processed sample (slice) 

        Get slice of sample data, and run it through the DSP block. This only the axes selected by the DSP block. E.g. if you have selected only accX and accY as inputs for the DSP block, but the raw sample also contains accZ, accZ is filtered out.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param slice_start: Begin index of the slice (required)
        :type slice_start: int
        :param slice_end: End index of the slice. If not given, the sample will be sliced to the same length as the impulse input block window length.
        :type slice_end: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DspRunResponseWithSample, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'dsp_id',
            'sample_id',
            'slice_start',
            'slice_end'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method run_dsp_sample_slice_read_only" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []
        if _params.get('slice_start') is not None:  # noqa: E501
            _query_params.append(('sliceStart', _params['slice_start']))
        if _params.get('slice_end') is not None:  # noqa: E501
            _query_params.append(('sliceEnd', _params['slice_end']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "DspRunResponseWithSample",
        }

        return self.api_client.call_api(
            '/api/{projectId}/dsp/{dspId}/raw-data/{sampleId}/slice/run/readonly', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def set_dsp_config(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], dsp_config_request : DSPConfigRequest, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Set config

        Set configuration parameters for the DSP block. Only values set in the body will be overwritten.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param dsp_config_request: (required)
        :type dsp_config_request: DSPConfigRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._set_dsp_config_with_http_info(project_id, dsp_id, dsp_config_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _set_dsp_config_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], dsp_config_request : DSPConfigRequest, **kwargs):  # noqa: E501
        """Set config 

        Set configuration parameters for the DSP block. Only values set in the body will be overwritten.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param dsp_config_request: (required)
        :type dsp_config_request: DSPConfigRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'dsp_id',
            'dsp_config_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_dsp_config" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['dsp_config_request']:
            _body_params = _params['dsp_config_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/dsp/{dspId}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def start_profile_custom_dsp_block(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], dsp_run_request_without_features_read_only : DspRunRequestWithoutFeaturesReadOnly, **kwargs) -> StartJobResponse:  # noqa: E501
        """Profile custom DSP block

        Returns performance characteristics for a custom DSP block (needs `hasTfliteImplementation`). Updates are streamed over the websocket API (or can be retrieved through the /stdout endpoint). Use getProfileTfliteJobResult to get the results when the job is completed.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param dsp_run_request_without_features_read_only: (required)
        :type dsp_run_request_without_features_read_only: DspRunRequestWithoutFeaturesReadOnly
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StartJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._start_profile_custom_dsp_block_with_http_info(project_id, dsp_id, dsp_run_request_without_features_read_only, **kwargs)  # noqa: E501

    @validate_arguments
    def _start_profile_custom_dsp_block_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], dsp_id : Annotated[StrictInt, Field(..., description="DSP Block ID, use the impulse functions to retrieve the ID")], dsp_run_request_without_features_read_only : DspRunRequestWithoutFeaturesReadOnly, **kwargs):  # noqa: E501
        """Profile custom DSP block 

        Returns performance characteristics for a custom DSP block (needs `hasTfliteImplementation`). Updates are streamed over the websocket API (or can be retrieved through the /stdout endpoint). Use getProfileTfliteJobResult to get the results when the job is completed.

        :param project_id: Project ID (required)
        :type project_id: int
        :param dsp_id: DSP Block ID, use the impulse functions to retrieve the ID (required)
        :type dsp_id: int
        :param dsp_run_request_without_features_read_only: (required)
        :type dsp_run_request_without_features_read_only: DspRunRequestWithoutFeaturesReadOnly
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StartJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'dsp_id',
            'dsp_run_request_without_features_read_only'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method start_profile_custom_dsp_block" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['dsp_id']:
            _path_params['dspId'] = _params['dsp_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['dsp_run_request_without_features_read_only']:
            _body_params = _params['dsp_run_request_without_features_read_only']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "StartJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/dsp/{dspId}/profile', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
