# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr

from typing import Optional

from edgeimpulse_api.models.clone_impulse_request import CloneImpulseRequest
from edgeimpulse_api.models.create_impulse_request import CreateImpulseRequest
from edgeimpulse_api.models.create_impulse_response import CreateImpulseResponse
from edgeimpulse_api.models.create_new_empty_impulse_response import CreateNewEmptyImpulseResponse
from edgeimpulse_api.models.generic_api_response import GenericApiResponse
from edgeimpulse_api.models.get_all_detailed_impulses_response import GetAllDetailedImpulsesResponse
from edgeimpulse_api.models.get_all_impulses_response import GetAllImpulsesResponse
from edgeimpulse_api.models.get_all_transfer_learning_models_response import GetAllTransferLearningModelsResponse
from edgeimpulse_api.models.get_impulse_blocks_response import GetImpulseBlocksResponse
from edgeimpulse_api.models.get_impulse_response import GetImpulseResponse
from edgeimpulse_api.models.get_new_block_id_response import GetNewBlockIdResponse
from edgeimpulse_api.models.set_impulse_thresholds_request import SetImpulseThresholdsRequest
from edgeimpulse_api.models.set_impulse_thresholds_response import SetImpulseThresholdsResponse
from edgeimpulse_api.models.start_job_response import StartJobResponse
from edgeimpulse_api.models.update_impulse_request import UpdateImpulseRequest
from edgeimpulse_api.models.verify_dsp_block_url_request import VerifyDspBlockUrlRequest
from edgeimpulse_api.models.verify_dsp_block_url_response import VerifyDspBlockUrlResponse

from edgeimpulse_api.api_client import ApiClient
from edgeimpulse_api.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ImpulseApi(object):
    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def clone_impulse_complete(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], impulse_id : Annotated[StrictInt, Field(..., description="Impulse ID")], clone_impulse_request : CloneImpulseRequest, **kwargs) -> StartJobResponse:  # noqa: E501
        """Clone impulse (complete)

        Clones the complete impulse (incl. config and data) of an existing impulse.

        :param project_id: Project ID (required)
        :type project_id: int
        :param impulse_id: Impulse ID (required)
        :type impulse_id: int
        :param clone_impulse_request: (required)
        :type clone_impulse_request: CloneImpulseRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StartJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._clone_impulse_complete_with_http_info(project_id, impulse_id, clone_impulse_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _clone_impulse_complete_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], impulse_id : Annotated[StrictInt, Field(..., description="Impulse ID")], clone_impulse_request : CloneImpulseRequest, **kwargs):  # noqa: E501
        """Clone impulse (complete) 

        Clones the complete impulse (incl. config and data) of an existing impulse.

        :param project_id: Project ID (required)
        :type project_id: int
        :param impulse_id: Impulse ID (required)
        :type impulse_id: int
        :param clone_impulse_request: (required)
        :type clone_impulse_request: CloneImpulseRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StartJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'impulse_id',
            'clone_impulse_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method clone_impulse_complete" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['impulse_id']:
            _path_params['impulseId'] = _params['impulse_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['clone_impulse_request']:
            _body_params = _params['clone_impulse_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "StartJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/impulse/{impulseId}/clone/complete', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def clone_impulse_structure(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], impulse_id : Annotated[StrictInt, Field(..., description="Impulse ID")], clone_impulse_request : CloneImpulseRequest, **kwargs) -> CreateImpulseResponse:  # noqa: E501
        """Clone impulse (structure)

        Clones the complete structure (incl. config) of an impulse. Does not copy data.

        :param project_id: Project ID (required)
        :type project_id: int
        :param impulse_id: Impulse ID (required)
        :type impulse_id: int
        :param clone_impulse_request: (required)
        :type clone_impulse_request: CloneImpulseRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreateImpulseResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._clone_impulse_structure_with_http_info(project_id, impulse_id, clone_impulse_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _clone_impulse_structure_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], impulse_id : Annotated[StrictInt, Field(..., description="Impulse ID")], clone_impulse_request : CloneImpulseRequest, **kwargs):  # noqa: E501
        """Clone impulse (structure) 

        Clones the complete structure (incl. config) of an impulse. Does not copy data.

        :param project_id: Project ID (required)
        :type project_id: int
        :param impulse_id: Impulse ID (required)
        :type impulse_id: int
        :param clone_impulse_request: (required)
        :type clone_impulse_request: CloneImpulseRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreateImpulseResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'impulse_id',
            'clone_impulse_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method clone_impulse_structure" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['impulse_id']:
            _path_params['impulseId'] = _params['impulse_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['clone_impulse_request']:
            _body_params = _params['clone_impulse_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "CreateImpulseResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/impulse/{impulseId}/clone/structure', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_impulse(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], impulse : CreateImpulseRequest, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs) -> CreateImpulseResponse:  # noqa: E501
        """Create impulse

        Sets the impulse for this project.  If you specify `impulseId` then that impulse is created/updated, otherwise the default impulse is created/updated.

        :param project_id: Project ID (required)
        :type project_id: int
        :param impulse: (required)
        :type impulse: CreateImpulseRequest
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreateImpulseResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._create_impulse_with_http_info(project_id, impulse, impulse_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _create_impulse_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], impulse : CreateImpulseRequest, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs):  # noqa: E501
        """Create impulse 

        Sets the impulse for this project.  If you specify `impulseId` then that impulse is created/updated, otherwise the default impulse is created/updated.

        :param project_id: Project ID (required)
        :type project_id: int
        :param impulse: (required)
        :type impulse: CreateImpulseRequest
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreateImpulseResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'impulse',
            'impulse_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_impulse" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('impulse_id') is not None:  # noqa: E501
            _query_params.append(('impulseId', _params['impulse_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['impulse']:
            _body_params = _params['impulse']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "CreateImpulseResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/impulse', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_new_empty_impulse(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> CreateNewEmptyImpulseResponse:  # noqa: E501
        """Create new empty impulse

        Create a new empty impulse, and return the ID.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: CreateNewEmptyImpulseResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._create_new_empty_impulse_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _create_new_empty_impulse_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Create new empty impulse 

        Create a new empty impulse, and return the ID.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(CreateNewEmptyImpulseResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_new_empty_impulse" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "CreateNewEmptyImpulseResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/impulse/new', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def delete_impulse(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Delete impulse

        Clears the impulse and all associated blocks for this project.  If you specify `impulseId` then that impulse is cleared, otherwise the default impulse is cleared.

        :param project_id: Project ID (required)
        :type project_id: int
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._delete_impulse_with_http_info(project_id, impulse_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _delete_impulse_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs):  # noqa: E501
        """Delete impulse 

        Clears the impulse and all associated blocks for this project.  If you specify `impulseId` then that impulse is cleared, otherwise the default impulse is cleared.

        :param project_id: Project ID (required)
        :type project_id: int
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'impulse_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_impulse" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('impulse_id') is not None:  # noqa: E501
            _query_params.append(('impulseId', _params['impulse_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/impulse', 'DELETE',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def download_detailed_impulses(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], format : Annotated[Optional[StrictStr], Field(description="Format of the detailed impulses response, either 'json' or 'csv'. If not set, defaults to 'json'.")] = None, **kwargs) -> str:  # noqa: E501
        """Download all impulses (incl. metrics), as JSON or CSV.

        Download all impulse for a project, including accuracy and performance metrics, as JSON or CSV.

        :param project_id: Project ID (required)
        :type project_id: int
        :param format: Format of the detailed impulses response, either 'json' or 'csv'. If not set, defaults to 'json'.
        :type format: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: str
        """
        kwargs['_return_http_data_only'] = True
        return self._download_detailed_impulses_with_http_info(project_id, format, **kwargs)  # noqa: E501

    @validate_arguments
    def _download_detailed_impulses_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], format : Annotated[Optional[StrictStr], Field(description="Format of the detailed impulses response, either 'json' or 'csv'. If not set, defaults to 'json'.")] = None, **kwargs):  # noqa: E501
        """Download all impulses (incl. metrics), as JSON or CSV. 

        Download all impulse for a project, including accuracy and performance metrics, as JSON or CSV.

        :param project_id: Project ID (required)
        :type project_id: int
        :param format: Format of the detailed impulses response, either 'json' or 'csv'. If not set, defaults to 'json'.
        :type format: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(str, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'format'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_detailed_impulses" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('format') is not None:  # noqa: E501
            _query_params.append(('format', _params['format']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "str",
        }

        return self.api_client.call_api(
            '/api/{projectId}/download-impulses-detailed', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_all_detailed_impulses(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> GetAllDetailedImpulsesResponse:  # noqa: E501
        """Get all impulses (incl. metrics)

        Retrieve all impulse for a project, including accuracy and performance metrics.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetAllDetailedImpulsesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_all_detailed_impulses_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_all_detailed_impulses_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Get all impulses (incl. metrics) 

        Retrieve all impulse for a project, including accuracy and performance metrics.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetAllDetailedImpulsesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_detailed_impulses" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetAllDetailedImpulsesResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/impulses-detailed', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_all_impulses(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> GetAllImpulsesResponse:  # noqa: E501
        """Get all impulses

        Retrieve all impulse for a project

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetAllImpulsesResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_all_impulses_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_all_impulses_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Get all impulses 

        Retrieve all impulse for a project

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetAllImpulsesResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_impulses" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetAllImpulsesResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/impulses', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_all_transfer_learning_models(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> GetAllTransferLearningModelsResponse:  # noqa: E501
        """Get all transfer learning models

        Retrieve all transfer learning models across all categories

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetAllTransferLearningModelsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_all_transfer_learning_models_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_all_transfer_learning_models_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Get all transfer learning models 

        Retrieve all transfer learning models across all categories

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetAllTransferLearningModelsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_transfer_learning_models" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetAllTransferLearningModelsResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/transfer-learning-models', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_impulse(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs) -> GetImpulseResponse:  # noqa: E501
        """Get impulse

        Retrieve the impulse for this project. If you specify `impulseId` then that impulse is returned, otherwise the default impulse is returned.

        :param project_id: Project ID (required)
        :type project_id: int
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetImpulseResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_impulse_with_http_info(project_id, impulse_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_impulse_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs):  # noqa: E501
        """Get impulse 

        Retrieve the impulse for this project. If you specify `impulseId` then that impulse is returned, otherwise the default impulse is returned.

        :param project_id: Project ID (required)
        :type project_id: int
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetImpulseResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'impulse_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_impulse" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('impulse_id') is not None:  # noqa: E501
            _query_params.append(('impulseId', _params['impulse_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetImpulseResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/impulse', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_impulse_all(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs) -> GetImpulseResponse:  # noqa: E501
        """Get impulse including disabled blocks

        Retrieve the impulse for this project including disabled blocks. If you specify `impulseId` then that impulse is returned, otherwise the default impulse is returned.

        :param project_id: Project ID (required)
        :type project_id: int
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetImpulseResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_impulse_all_with_http_info(project_id, impulse_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_impulse_all_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs):  # noqa: E501
        """Get impulse including disabled blocks 

        Retrieve the impulse for this project including disabled blocks. If you specify `impulseId` then that impulse is returned, otherwise the default impulse is returned.

        :param project_id: Project ID (required)
        :type project_id: int
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetImpulseResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'impulse_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_impulse_all" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('impulse_id') is not None:  # noqa: E501
            _query_params.append(('impulseId', _params['impulse_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetImpulseResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/impulse/all', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_impulse_blocks(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> GetImpulseBlocksResponse:  # noqa: E501
        """Get impulse blocks

        Lists all possible blocks that can be used in the impulse

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetImpulseBlocksResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_impulse_blocks_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_impulse_blocks_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Get impulse blocks 

        Lists all possible blocks that can be used in the impulse

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetImpulseBlocksResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_impulse_blocks" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetImpulseBlocksResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/impulse/blocks', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_new_block_id(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs) -> GetNewBlockIdResponse:  # noqa: E501
        """Get new block ID

        Returns an unused block ID. Use this function to determine new block IDs when you construct an impulse; so you won't accidentally re-use block IDs.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetNewBlockIdResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_new_block_id_with_http_info(project_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_new_block_id_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], **kwargs):  # noqa: E501
        """Get new block ID 

        Returns an unused block ID. Use this function to determine new block IDs when you construct an impulse; so you won't accidentally re-use block IDs.

        :param project_id: Project ID (required)
        :type project_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetNewBlockIdResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_new_block_id" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetNewBlockIdResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/impulse/get-new-block-id', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def regenerate_model_testing_summary(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], impulse_id : Annotated[StrictInt, Field(..., description="Impulse ID")], **kwargs) -> StartJobResponse:  # noqa: E501
        """Regenerate model testing summary

        Regenerate model testing results (without re-running feature generation). Use this if thresholds changed (e.g. via setImpulseThresholds), but no job was kicked off automatically.

        :param project_id: Project ID (required)
        :type project_id: int
        :param impulse_id: Impulse ID (required)
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StartJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._regenerate_model_testing_summary_with_http_info(project_id, impulse_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _regenerate_model_testing_summary_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], impulse_id : Annotated[StrictInt, Field(..., description="Impulse ID")], **kwargs):  # noqa: E501
        """Regenerate model testing summary 

        Regenerate model testing results (without re-running feature generation). Use this if thresholds changed (e.g. via setImpulseThresholds), but no job was kicked off automatically.

        :param project_id: Project ID (required)
        :type project_id: int
        :param impulse_id: Impulse ID (required)
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StartJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'impulse_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method regenerate_model_testing_summary" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['impulse_id']:
            _path_params['impulseId'] = _params['impulse_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "StartJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/impulse/{impulseId}/regenerate-model-testing-summary', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def set_impulse_thresholds(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], impulse_id : Annotated[StrictInt, Field(..., description="Impulse ID")], set_impulse_thresholds_request : SetImpulseThresholdsRequest, **kwargs) -> SetImpulseThresholdsResponse:  # noqa: E501
        """Set thresholds

        Set thresholds (e.g. min. confidence rating, or min. anomaly score) for an impulse.

        :param project_id: Project ID (required)
        :type project_id: int
        :param impulse_id: Impulse ID (required)
        :type impulse_id: int
        :param set_impulse_thresholds_request: (required)
        :type set_impulse_thresholds_request: SetImpulseThresholdsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SetImpulseThresholdsResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._set_impulse_thresholds_with_http_info(project_id, impulse_id, set_impulse_thresholds_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _set_impulse_thresholds_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], impulse_id : Annotated[StrictInt, Field(..., description="Impulse ID")], set_impulse_thresholds_request : SetImpulseThresholdsRequest, **kwargs):  # noqa: E501
        """Set thresholds 

        Set thresholds (e.g. min. confidence rating, or min. anomaly score) for an impulse.

        :param project_id: Project ID (required)
        :type project_id: int
        :param impulse_id: Impulse ID (required)
        :type impulse_id: int
        :param set_impulse_thresholds_request: (required)
        :type set_impulse_thresholds_request: SetImpulseThresholdsRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SetImpulseThresholdsResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'impulse_id',
            'set_impulse_thresholds_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_impulse_thresholds" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['impulse_id']:
            _path_params['impulseId'] = _params['impulse_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['set_impulse_thresholds_request']:
            _body_params = _params['set_impulse_thresholds_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "SetImpulseThresholdsResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/impulse/{impulseId}/set-thresholds', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_impulse(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], update_impulse_request : UpdateImpulseRequest, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Update impulse

        Update the impulse for this project.  If you specify `impulseId` then that impulse is created/updated, otherwise the default impulse is created/updated.

        :param project_id: Project ID (required)
        :type project_id: int
        :param update_impulse_request: (required)
        :type update_impulse_request: UpdateImpulseRequest
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._update_impulse_with_http_info(project_id, update_impulse_request, impulse_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _update_impulse_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], update_impulse_request : UpdateImpulseRequest, impulse_id : Annotated[Optional[StrictInt], Field(description="Impulse ID. If this is unset then the default impulse is used.")] = None, **kwargs):  # noqa: E501
        """Update impulse 

        Update the impulse for this project.  If you specify `impulseId` then that impulse is created/updated, otherwise the default impulse is created/updated.

        :param project_id: Project ID (required)
        :type project_id: int
        :param update_impulse_request: (required)
        :type update_impulse_request: UpdateImpulseRequest
        :param impulse_id: Impulse ID. If this is unset then the default impulse is used.
        :type impulse_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'update_impulse_request',
            'impulse_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_impulse" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []
        if _params.get('impulse_id') is not None:  # noqa: E501
            _query_params.append(('impulseId', _params['impulse_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['update_impulse_request']:
            _body_params = _params['update_impulse_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/impulse/update', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def verify_dsp_block_url(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], verify_dsp_block_url_request : VerifyDspBlockUrlRequest, **kwargs) -> VerifyDspBlockUrlResponse:  # noqa: E501
        """Verify custom DSP block

        Verify the validity of a custom DSP block

        :param project_id: Project ID (required)
        :type project_id: int
        :param verify_dsp_block_url_request: (required)
        :type verify_dsp_block_url_request: VerifyDspBlockUrlRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: VerifyDspBlockUrlResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._verify_dsp_block_url_with_http_info(project_id, verify_dsp_block_url_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _verify_dsp_block_url_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], verify_dsp_block_url_request : VerifyDspBlockUrlRequest, **kwargs):  # noqa: E501
        """Verify custom DSP block 

        Verify the validity of a custom DSP block

        :param project_id: Project ID (required)
        :type project_id: int
        :param verify_dsp_block_url_request: (required)
        :type verify_dsp_block_url_request: VerifyDspBlockUrlRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(VerifyDspBlockUrlResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'verify_dsp_block_url_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method verify_dsp_block_url" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['verify_dsp_block_url_request']:
            _body_params = _params['verify_dsp_block_url_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "VerifyDspBlockUrlResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/verify-dsp-block/url', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
