# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictInt

from edgeimpulse_api.models.generic_api_response import GenericApiResponse
from edgeimpulse_api.models.get_post_processing_results_for_sample_response import GetPostProcessingResultsForSampleResponse
from edgeimpulse_api.models.post_processing_config_request import PostProcessingConfigRequest
from edgeimpulse_api.models.post_processing_config_response import PostProcessingConfigResponse
from edgeimpulse_api.models.start_job_response import StartJobResponse

from edgeimpulse_api.api_client import ApiClient
from edgeimpulse_api.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class PostProcessingApi(object):
    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def generate_post_processing_features_for_sample(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], post_processing_id : Annotated[StrictInt, Field(..., description="Post-processing Block ID, use the impulse functions to retrieve the ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], post_processing_config_request : PostProcessingConfigRequest, **kwargs) -> StartJobResponse:  # noqa: E501
        """Classify sample with post-processing

        Classify a sample using post-processing parameters. Sample should be in the post-processing dataset.

        :param project_id: Project ID (required)
        :type project_id: int
        :param post_processing_id: Post-processing Block ID, use the impulse functions to retrieve the ID (required)
        :type post_processing_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param post_processing_config_request: (required)
        :type post_processing_config_request: PostProcessingConfigRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: StartJobResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._generate_post_processing_features_for_sample_with_http_info(project_id, post_processing_id, sample_id, post_processing_config_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _generate_post_processing_features_for_sample_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], post_processing_id : Annotated[StrictInt, Field(..., description="Post-processing Block ID, use the impulse functions to retrieve the ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], post_processing_config_request : PostProcessingConfigRequest, **kwargs):  # noqa: E501
        """Classify sample with post-processing 

        Classify a sample using post-processing parameters. Sample should be in the post-processing dataset.

        :param project_id: Project ID (required)
        :type project_id: int
        :param post_processing_id: Post-processing Block ID, use the impulse functions to retrieve the ID (required)
        :type post_processing_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param post_processing_config_request: (required)
        :type post_processing_config_request: PostProcessingConfigRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(StartJobResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'post_processing_id',
            'sample_id',
            'post_processing_config_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_post_processing_features_for_sample" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['post_processing_id']:
            _path_params['postProcessingId'] = _params['post_processing_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['post_processing_config_request']:
            _body_params = _params['post_processing_config_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "StartJobResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/post-processing/{postProcessingId}/samples/{sampleId}/classify', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_post_processing_config(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], post_processing_id : Annotated[StrictInt, Field(..., description="Post-processing Block ID, use the impulse functions to retrieve the ID")], **kwargs) -> PostProcessingConfigResponse:  # noqa: E501
        """Get post-processing block config

        Retrieve the configuration parameters for a post-processing block. Use the impulse functions to retrieve all post-processing blocks.

        :param project_id: Project ID (required)
        :type project_id: int
        :param post_processing_id: Post-processing Block ID, use the impulse functions to retrieve the ID (required)
        :type post_processing_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: PostProcessingConfigResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_post_processing_config_with_http_info(project_id, post_processing_id, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_post_processing_config_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], post_processing_id : Annotated[StrictInt, Field(..., description="Post-processing Block ID, use the impulse functions to retrieve the ID")], **kwargs):  # noqa: E501
        """Get post-processing block config 

        Retrieve the configuration parameters for a post-processing block. Use the impulse functions to retrieve all post-processing blocks.

        :param project_id: Project ID (required)
        :type project_id: int
        :param post_processing_id: Post-processing Block ID, use the impulse functions to retrieve the ID (required)
        :type post_processing_id: int
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(PostProcessingConfigResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'post_processing_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_post_processing_config" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['post_processing_id']:
            _path_params['postProcessingId'] = _params['post_processing_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "PostProcessingConfigResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/post-processing/{postProcessingId}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_post_processing_results_for_sample(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], post_processing_id : Annotated[StrictInt, Field(..., description="Post-processing Block ID, use the impulse functions to retrieve the ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], post_processing_config_request : PostProcessingConfigRequest, **kwargs) -> GetPostProcessingResultsForSampleResponse:  # noqa: E501
        """Check post-processing results for sample

        Retrieve post-processing results for a specific sample, e.g. whether it has generated features already.

        :param project_id: Project ID (required)
        :type project_id: int
        :param post_processing_id: Post-processing Block ID, use the impulse functions to retrieve the ID (required)
        :type post_processing_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param post_processing_config_request: (required)
        :type post_processing_config_request: PostProcessingConfigRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GetPostProcessingResultsForSampleResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._get_post_processing_results_for_sample_with_http_info(project_id, post_processing_id, sample_id, post_processing_config_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _get_post_processing_results_for_sample_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], post_processing_id : Annotated[StrictInt, Field(..., description="Post-processing Block ID, use the impulse functions to retrieve the ID")], sample_id : Annotated[StrictInt, Field(..., description="Sample ID")], post_processing_config_request : PostProcessingConfigRequest, **kwargs):  # noqa: E501
        """Check post-processing results for sample 

        Retrieve post-processing results for a specific sample, e.g. whether it has generated features already.

        :param project_id: Project ID (required)
        :type project_id: int
        :param post_processing_id: Post-processing Block ID, use the impulse functions to retrieve the ID (required)
        :type post_processing_id: int
        :param sample_id: Sample ID (required)
        :type sample_id: int
        :param post_processing_config_request: (required)
        :type post_processing_config_request: PostProcessingConfigRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GetPostProcessingResultsForSampleResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'post_processing_id',
            'sample_id',
            'post_processing_config_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_post_processing_results_for_sample" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['post_processing_id']:
            _path_params['postProcessingId'] = _params['post_processing_id']
        if _params['sample_id']:
            _path_params['sampleId'] = _params['sample_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['post_processing_config_request']:
            _body_params = _params['post_processing_config_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GetPostProcessingResultsForSampleResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/post-processing/{postProcessingId}/samples/{sampleId}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def set_post_processing_config(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], post_processing_id : Annotated[StrictInt, Field(..., description="Post-processing Block ID, use the impulse functions to retrieve the ID")], post_processing_config_request : PostProcessingConfigRequest, **kwargs) -> GenericApiResponse:  # noqa: E501
        """Set post-processing block config

        Set configuration parameters for a post-processing block. Only values set in the body will be overwritten.

        :param project_id: Project ID (required)
        :type project_id: int
        :param post_processing_id: Post-processing Block ID, use the impulse functions to retrieve the ID (required)
        :type post_processing_id: int
        :param post_processing_config_request: (required)
        :type post_processing_config_request: PostProcessingConfigRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GenericApiResponse
        """
        kwargs['_return_http_data_only'] = True
        return self._set_post_processing_config_with_http_info(project_id, post_processing_id, post_processing_config_request, **kwargs)  # noqa: E501

    @validate_arguments
    def _set_post_processing_config_with_http_info(self, project_id : Annotated[StrictInt, Field(..., description="Project ID")], post_processing_id : Annotated[StrictInt, Field(..., description="Post-processing Block ID, use the impulse functions to retrieve the ID")], post_processing_config_request : PostProcessingConfigRequest, **kwargs):  # noqa: E501
        """Set post-processing block config 

        Set configuration parameters for a post-processing block. Only values set in the body will be overwritten.

        :param project_id: Project ID (required)
        :type project_id: int
        :param post_processing_id: Post-processing Block ID, use the impulse functions to retrieve the ID (required)
        :type post_processing_id: int
        :param post_processing_config_request: (required)
        :type post_processing_config_request: PostProcessingConfigRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GenericApiResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'project_id',
            'post_processing_id',
            'post_processing_config_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_post_processing_config" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['project_id']:
            _path_params['projectId'] = _params['project_id']
        if _params['post_processing_id']:
            _path_params['postProcessingId'] = _params['post_processing_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['post_processing_config_request']:
            _body_params = _params['post_processing_config_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['ApiKeyAuthentication', 'OAuth2', 'OAuth2', 'OAuth2', 'OAuth2', 'JWTAuthentication', 'JWTHttpHeaderAuthentication']  # noqa: E501

        _response_types_map = {
            '200': "GenericApiResponse",
        }

        return self.api_client.call_api(
            '/api/{projectId}/post-processing/{postProcessingId}', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
