# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from edgeimpulse_api.models.daily_metrics_record import DailyMetricsRecord
from edgeimpulse_api.models.enterprise_trial import EnterpriseTrial
from edgeimpulse_api.models.permission import Permission
from edgeimpulse_api.models.project import Project
from edgeimpulse_api.models.staff_info import StaffInfo
from edgeimpulse_api.models.user_experiment import UserExperiment
from edgeimpulse_api.models.user_organization import UserOrganization
from edgeimpulse_api.models.user_tier_enum import UserTierEnum

class AdminApiUser(BaseModel):
    id: StrictInt = ...
    username: StrictStr = ...
    name: StrictStr = ...
    email: StrictStr = ...
    photo: Optional[StrictStr] = None
    created: datetime = ...
    last_seen: Optional[datetime] = Field(None, alias="lastSeen")
    staff_info: StaffInfo = Field(..., alias="staffInfo")
    pending: StrictBool = ...
    job_title: Optional[StrictStr] = Field(None, alias="jobTitle")
    permissions: Optional[List[Permission]] = Field(None, description="List of permissions the user has")
    company_name: Optional[StrictStr] = Field(None, alias="companyName")
    activated: StrictBool = ...
    mfa_configured: StrictBool = Field(..., alias="mfaConfigured", description="Whether the user has configured multi-factor authentication")
    stripe_customer_id: Optional[StrictStr] = Field(None, alias="stripeCustomerId", description="Stripe customer ID, if any.")
    has_pending_payments: Optional[StrictBool] = Field(None, alias="hasPendingPayments", description="Whether the user has pending payments.")
    tier: UserTierEnum = ...
    idps: Optional[List[StrictStr]] = Field(None, description="List of identity providers (e.g. Google, GitHub) that the user has used to sign in with")
    organizations: List[UserOrganization] = Field(..., description="Organizations that the user is a member of. Only filled when requesting information about yourself.")
    projects: List[Project] = ...
    experiments: List[UserExperiment] = Field(..., description="Experiments the user has access to. Enabling experiments can only be done through a JWT token.")
    evaluation: Optional[StrictBool] = Field(None, description="Whether this is an ephemeral evaluation account.")
    ambassador: Optional[StrictBool] = Field(None, description="Whether this user is an ambassador.")
    suspended: StrictBool = Field(..., description="Whether the user is suspended.")
    trials: List[EnterpriseTrial] = Field(..., description="Current or past enterprise trials.")
    daily_metrics: Optional[List[DailyMetricsRecord]] = Field(None, alias="dailyMetrics", description="Metrics for the last 365 days")
    __properties = ["id", "username", "name", "email", "photo", "created", "lastSeen", "staffInfo", "pending", "jobTitle", "permissions", "companyName", "activated", "mfaConfigured", "stripeCustomerId", "hasPendingPayments", "tier", "idps", "organizations", "projects", "experiments", "evaluation", "ambassador", "suspended", "trials", "dailyMetrics"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> AdminApiUser:
        """Create an instance of AdminApiUser from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of staff_info
        if self.staff_info:
            _dict['staffInfo'] = self.staff_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in organizations (list)
        _items = []
        if self.organizations:
            for _item in self.organizations:
                if _item:
                    _items.append(_item.to_dict())
            _dict['organizations'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in projects (list)
        _items = []
        if self.projects:
            for _item in self.projects:
                if _item:
                    _items.append(_item.to_dict())
            _dict['projects'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in experiments (list)
        _items = []
        if self.experiments:
            for _item in self.experiments:
                if _item:
                    _items.append(_item.to_dict())
            _dict['experiments'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in trials (list)
        _items = []
        if self.trials:
            for _item in self.trials:
                if _item:
                    _items.append(_item.to_dict())
            _dict['trials'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in daily_metrics (list)
        _items = []
        if self.daily_metrics:
            for _item in self.daily_metrics:
                if _item:
                    _items.append(_item.to_dict())
            _dict['dailyMetrics'] = _items
        # set to None if daily_metrics (nullable) is None
        if self.daily_metrics is None:
            _dict['dailyMetrics'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AdminApiUser:
        """Create an instance of AdminApiUser from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AdminApiUser.construct(**obj)

        _obj = AdminApiUser.construct(**{
            "id": obj.get("id"),
            "username": obj.get("username"),
            "name": obj.get("name"),
            "email": obj.get("email"),
            "photo": obj.get("photo"),
            "created": obj.get("created"),
            "last_seen": obj.get("lastSeen"),
            "staff_info": StaffInfo.from_dict(obj.get("staffInfo")) if obj.get("staffInfo") is not None else None,
            "pending": obj.get("pending"),
            "job_title": obj.get("jobTitle"),
            "permissions": obj.get("permissions"),
            "company_name": obj.get("companyName"),
            "activated": obj.get("activated"),
            "mfa_configured": obj.get("mfaConfigured"),
            "stripe_customer_id": obj.get("stripeCustomerId"),
            "has_pending_payments": obj.get("hasPendingPayments"),
            "tier": obj.get("tier"),
            "idps": obj.get("idps"),
            "organizations": [UserOrganization.from_dict(_item) for _item in obj.get("organizations")] if obj.get("organizations") is not None else None,
            "projects": [Project.from_dict(_item) for _item in obj.get("projects")] if obj.get("projects") is not None else None,
            "experiments": [UserExperiment.from_dict(_item) for _item in obj.get("experiments")] if obj.get("experiments") is not None else None,
            "evaluation": obj.get("evaluation"),
            "ambassador": obj.get("ambassador"),
            "suspended": obj.get("suspended"),
            "trials": [EnterpriseTrial.from_dict(_item) for _item in obj.get("trials")] if obj.get("trials") is not None else None,
            "daily_metrics": [DailyMetricsRecord.from_dict(_item) for _item in obj.get("dailyMetrics")] if obj.get("dailyMetrics") is not None else None
        })
        return _obj

