# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Dict, List, Optional
from pydantic import BaseModel, Field
from edgeimpulse_api.models.anomaly_result import AnomalyResult
from edgeimpulse_api.models.block_threshold import BlockThreshold
from edgeimpulse_api.models.classify_sample_response_classification_details import ClassifySampleResponseClassificationDetails
from edgeimpulse_api.models.impulse_learn_block import ImpulseLearnBlock
from edgeimpulse_api.models.object_detection_last_layer import ObjectDetectionLastLayer
from edgeimpulse_api.models.structured_classify_result import StructuredClassifyResult
from edgeimpulse_api.models.structured_label import StructuredLabel

class ClassifySampleResponseClassification(BaseModel):
    learn_block: ImpulseLearnBlock = Field(..., alias="learnBlock")
    result: List[Dict[str, float]] = Field(..., description="Classification result, one item per window.")
    anomaly_result: Optional[List[AnomalyResult]] = Field(None, alias="anomalyResult", description="Anomaly scores and computed metrics for visual anomaly detection, one item per window.")
    structured_result: Optional[List[StructuredClassifyResult]] = Field(None, alias="structuredResult", description="Results of inferencing that returns structured data, such as object detection")
    minimum_confidence_rating: float = Field(..., alias="minimumConfidenceRating", description="DEPRECATED, see \"thresholds\" instead. The minimum confidence rating for this block. For regression, this is the absolute error (which can be larger than 1).")
    details: Optional[List[ClassifySampleResponseClassificationDetails]] = Field(None, description="Structured outputs and computed metrics for some model types (e.g. object detection), one item per window.")
    object_detection_last_layer: Optional[ObjectDetectionLastLayer] = Field(None, alias="objectDetectionLastLayer")
    expected_labels: List[StructuredLabel] = Field(..., alias="expectedLabels", description="An array with an expected label per window.")
    thresholds: List[BlockThreshold] = Field(..., description="List of configurable thresholds for this block.")
    __properties = ["learnBlock", "result", "anomalyResult", "structuredResult", "minimumConfidenceRating", "details", "objectDetectionLastLayer", "expectedLabels", "thresholds"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> ClassifySampleResponseClassification:
        """Create an instance of ClassifySampleResponseClassification from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of learn_block
        if self.learn_block:
            _dict['learnBlock'] = self.learn_block.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in anomaly_result (list)
        _items = []
        if self.anomaly_result:
            for _item in self.anomaly_result:
                if _item:
                    _items.append(_item.to_dict())
            _dict['anomalyResult'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in structured_result (list)
        _items = []
        if self.structured_result:
            for _item in self.structured_result:
                if _item:
                    _items.append(_item.to_dict())
            _dict['structuredResult'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in details (list)
        _items = []
        if self.details:
            for _item in self.details:
                if _item:
                    _items.append(_item.to_dict())
            _dict['details'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in expected_labels (list)
        _items = []
        if self.expected_labels:
            for _item in self.expected_labels:
                if _item:
                    _items.append(_item.to_dict())
            _dict['expectedLabels'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in thresholds (list)
        _items = []
        if self.thresholds:
            for _item in self.thresholds:
                if _item:
                    _items.append(_item.to_dict())
            _dict['thresholds'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ClassifySampleResponseClassification:
        """Create an instance of ClassifySampleResponseClassification from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ClassifySampleResponseClassification.construct(**obj)

        _obj = ClassifySampleResponseClassification.construct(**{
            "learn_block": ImpulseLearnBlock.from_dict(obj.get("learnBlock")) if obj.get("learnBlock") is not None else None,
            "result": obj.get("result"),
            "anomaly_result": [AnomalyResult.from_dict(_item) for _item in obj.get("anomalyResult")] if obj.get("anomalyResult") is not None else None,
            "structured_result": [StructuredClassifyResult.from_dict(_item) for _item in obj.get("structuredResult")] if obj.get("structuredResult") is not None else None,
            "minimum_confidence_rating": obj.get("minimumConfidenceRating"),
            "details": [ClassifySampleResponseClassificationDetails.from_dict(_item) for _item in obj.get("details")] if obj.get("details") is not None else None,
            "object_detection_last_layer": obj.get("objectDetectionLastLayer"),
            "expected_labels": [StructuredLabel.from_dict(_item) for _item in obj.get("expectedLabels")] if obj.get("expectedLabels") is not None else None,
            "thresholds": [BlockThreshold.from_dict(_item) for _item in obj.get("thresholds")] if obj.get("thresholds") is not None else None
        })
        return _obj

