# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, validator
from edgeimpulse_api.models.deploy_pretrained_model_request_model_info import DeployPretrainedModelRequestModelInfo
from edgeimpulse_api.models.deployment_target_engine import DeploymentTargetEngine

class DeployPretrainedModelRequest(BaseModel):
    model_file_base64: StrictStr = Field(..., alias="modelFileBase64", description="A base64 encoded pretrained model")
    model_file_type: StrictStr = Field(..., alias="modelFileType")
    deployment_type: StrictStr = Field(..., alias="deploymentType", description="The name of the built target. You can find this by listing all deployment targets through `listDeploymentTargetsForProject` (via `GET /v1/api/{projectId}/deployment/targets`) and see the `format` type.")
    engine: Optional[DeploymentTargetEngine] = None
    model_info: DeployPretrainedModelRequestModelInfo = Field(..., alias="modelInfo")
    representative_features_base64: Optional[StrictStr] = Field(None, alias="representativeFeaturesBase64", description="A base64 encoded .npy file containing the features from your validation set (optional for onnx and saved_model) - used to quantize your model.")
    deploy_model_type: Optional[StrictStr] = Field(None, alias="deployModelType")
    use_converter: Optional[StrictStr] = Field(None, alias="useConverter", description="Optional, use a specific converter (only for ONNX models).")
    __properties = ["modelFileBase64", "modelFileType", "deploymentType", "engine", "modelInfo", "representativeFeaturesBase64", "deployModelType", "useConverter"]

    @validator('model_file_type')
    def model_file_type_validate_enum(cls, v):
        if v not in ('tflite', 'onnx', 'saved_model', 'lgbm', 'xgboost', 'pickle'):
            raise ValueError("must validate the enum values ('tflite', 'onnx', 'saved_model', 'lgbm', 'xgboost', 'pickle')")
        return v

    @validator('deploy_model_type')
    def deploy_model_type_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('int8', 'float32'):
            raise ValueError("must validate the enum values ('int8', 'float32')")
        return v

    @validator('use_converter')
    def use_converter_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('onnx-tf', 'onnx2tf'):
            raise ValueError("must validate the enum values ('onnx-tf', 'onnx2tf')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> DeployPretrainedModelRequest:
        """Create an instance of DeployPretrainedModelRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of model_info
        if self.model_info:
            _dict['modelInfo'] = self.model_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DeployPretrainedModelRequest:
        """Create an instance of DeployPretrainedModelRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return DeployPretrainedModelRequest.construct(**obj)

        _obj = DeployPretrainedModelRequest.construct(**{
            "model_file_base64": obj.get("modelFileBase64"),
            "model_file_type": obj.get("modelFileType"),
            "deployment_type": obj.get("deploymentType"),
            "engine": obj.get("engine"),
            "model_info": DeployPretrainedModelRequestModelInfo.from_dict(obj.get("modelInfo")) if obj.get("modelInfo") is not None else None,
            "representative_features_base64": obj.get("representativeFeaturesBase64"),
            "deploy_model_type": obj.get("deployModelType"),
            "use_converter": obj.get("useConverter")
        })
        return _obj

