# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, validator
from edgeimpulse_api.models.dsp_group_item_select_options_inner import DSPGroupItemSelectOptionsInner
from edgeimpulse_api.models.dsp_group_item_show_if import DSPGroupItemShowIf

class DSPGroupItem(BaseModel):
    name: StrictStr = ...
    value: Optional[StrictStr] = None
    default_value: StrictStr = Field(..., alias="defaultValue")
    type: StrictStr = ...
    help: Optional[StrictStr] = None
    param: StrictStr = ...
    select_options: Optional[List[DSPGroupItemSelectOptionsInner]] = Field(None, alias="selectOptions")
    readonly: StrictBool = ...
    should_show: StrictBool = Field(..., alias="shouldShow")
    show_if: Optional[DSPGroupItemShowIf] = Field(None, alias="showIf")
    invalid_text: Optional[StrictStr] = Field(None, alias="invalidText")
    section: Optional[StrictStr] = Field(None, description="Interface section to render parameter in.")
    multiline: Optional[StrictBool] = Field(None, description="Only valid for type \"string\". Will render a multiline text area.")
    required: StrictBool = ...
    hint: Optional[StrictStr] = Field(None, description="If set, shows a hint below the input.")
    placeholder: Optional[StrictStr] = Field(None, description="Sets the placeholder text on the input element (for types \"string\", \"int\", \"float\" and \"secret\")")
    show_click_to_set: StrictBool = Field(..., alias="showClickToSet", description="If enabled, render a disabled input element with 'Click to set'")
    valid: Optional[List[Dict[str, Any]]] = Field(None, description="Valid values for parameter.")
    items: Optional[Dict[str, Any]] = Field(None, description="Recursive definition for items of a parameter with type 'array'.")
    properties: Optional[Dict[str, Any]] = Field(None, description="Recursive definition for a parameter with type 'object'.")
    __properties = ["name", "value", "defaultValue", "type", "help", "param", "selectOptions", "readonly", "shouldShow", "showIf", "invalidText", "section", "multiline", "required", "hint", "placeholder", "showClickToSet", "valid", "items", "properties"]

    @validator('section')
    def section_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('advanced', 'augmentation', 'modelProfiling'):
            raise ValueError("must validate the enum values ('advanced', 'augmentation', 'modelProfiling')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> DSPGroupItem:
        """Create an instance of DSPGroupItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in select_options (list)
        _items = []
        if self.select_options:
            for _item in self.select_options:
                if _item:
                    _items.append(_item.to_dict())
            _dict['selectOptions'] = _items
        # override the default output from pydantic by calling `to_dict()` of show_if
        if self.show_if:
            _dict['showIf'] = self.show_if.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DSPGroupItem:
        """Create an instance of DSPGroupItem from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return DSPGroupItem.construct(**obj)

        _obj = DSPGroupItem.construct(**{
            "name": obj.get("name"),
            "value": obj.get("value"),
            "default_value": obj.get("defaultValue"),
            "type": obj.get("type"),
            "help": obj.get("help"),
            "param": obj.get("param"),
            "select_options": [DSPGroupItemSelectOptionsInner.from_dict(_item) for _item in obj.get("selectOptions")] if obj.get("selectOptions") is not None else None,
            "readonly": obj.get("readonly"),
            "should_show": obj.get("shouldShow"),
            "show_if": DSPGroupItemShowIf.from_dict(obj.get("showIf")) if obj.get("showIf") is not None else None,
            "invalid_text": obj.get("invalidText"),
            "section": obj.get("section"),
            "multiline": obj.get("multiline"),
            "required": obj.get("required"),
            "hint": obj.get("hint"),
            "placeholder": obj.get("placeholder"),
            "show_click_to_set": obj.get("showClickToSet"),
            "valid": obj.get("valid"),
            "items": obj.get("items"),
            "properties": obj.get("properties")
        })
        return _obj

