# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr
from edgeimpulse_api.models.dsp_run_graph_axis_labels import DspRunGraphAxisLabels

class DspRunGraph(BaseModel):
    name: StrictStr = Field(..., description="Name of the graph")
    image: Optional[StrictStr] = Field(None, description="Base64 encoded image, only present if type is 'image'")
    image_mime_type: Optional[StrictStr] = Field(None, alias="imageMimeType", description="Mime type of the Base64 encoded image, only present if type is 'image'")
    x: Optional[Dict[str, List[float]]] = Field(None, alias="X", description="Values on the x-axis per plot. Key is the name of the raw feature. Present if type is 'logarithmic' or 'linear'.")
    y: Optional[List[float]] = Field(None, description="Values of the y-axis. Present if type is 'logarithmic' or 'linear'.")
    suggested_x_min: Optional[float] = Field(None, alias="suggestedXMin", description="Suggested minimum value of x-axis")
    suggested_x_max: Optional[float] = Field(None, alias="suggestedXMax", description="Suggested maxium value of x-axis")
    suggested_y_min: Optional[float] = Field(None, alias="suggestedYMin", description="Suggested minimum value of y-axis")
    suggested_y_max: Optional[float] = Field(None, alias="suggestedYMax", description="Suggested maximum value of y-axis")
    type: StrictStr = Field(..., description="Type of graph (either `logarithmic`, `linear` or `image`)")
    line_width: Optional[float] = Field(None, alias="lineWidth", description="Width of the graph line (if type is `logarithmic` or `linear`). Default 3.")
    smoothing: Optional[StrictBool] = Field(None, description="Whether to apply smoothing to the graph.")
    axis_labels: Optional[DspRunGraphAxisLabels] = Field(None, alias="axisLabels")
    highlights: Optional[Dict[str, List[float]]] = Field(None, description="Indices of points to highlight, per axis.")
    __properties = ["name", "image", "imageMimeType", "X", "y", "suggestedXMin", "suggestedXMax", "suggestedYMin", "suggestedYMax", "type", "lineWidth", "smoothing", "axisLabels", "highlights"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> DspRunGraph:
        """Create an instance of DspRunGraph from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of axis_labels
        if self.axis_labels:
            _dict['axisLabels'] = self.axis_labels.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DspRunGraph:
        """Create an instance of DspRunGraph from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return DspRunGraph.construct(**obj)

        _obj = DspRunGraph.construct(**{
            "name": obj.get("name"),
            "image": obj.get("image"),
            "image_mime_type": obj.get("imageMimeType"),
            "x": obj.get("X"),
            "y": obj.get("y"),
            "suggested_x_min": obj.get("suggestedXMin"),
            "suggested_x_max": obj.get("suggestedXMax"),
            "suggested_y_min": obj.get("suggestedYMin"),
            "suggested_y_max": obj.get("suggestedYMax"),
            "type": obj.get("type"),
            "line_width": obj.get("lineWidth"),
            "smoothing": obj.get("smoothing"),
            "axis_labels": DspRunGraphAxisLabels.from_dict(obj.get("axisLabels")) if obj.get("axisLabels") is not None else None,
            "highlights": obj.get("highlights")
        })
        return _obj

