# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from edgeimpulse_api.models.list_versions_response_all_of_custom_learn_blocks import ListVersionsResponseAllOfCustomLearnBlocks
from edgeimpulse_api.models.list_versions_response_all_of_versions import ListVersionsResponseAllOfVersions

class ListVersionsResponse(BaseModel):
    success: StrictBool = Field(..., description="Whether the operation succeeded")
    error: Optional[StrictStr] = Field(None, description="Optional error description (set if 'success' was false)")
    next_version: StrictInt = Field(..., alias="nextVersion")
    versions: List[ListVersionsResponseAllOfVersions] = ...
    custom_learn_blocks: List[ListVersionsResponseAllOfCustomLearnBlocks] = Field(..., alias="customLearnBlocks", description="If you have any custom learn blocks (e.g. blocks you pushed through Bring Your Own Model), then these are listed here. We use these to show a warning in the UI that these blocks will also be available in a public version.")
    run_model_testing_while_versioning: StrictBool = Field(..., alias="runModelTestingWhileVersioning", description="Whether the 'Run model testing while versioning' checkbox should be enabled.")
    __properties = ["success", "error", "nextVersion", "versions", "customLearnBlocks", "runModelTestingWhileVersioning"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> ListVersionsResponse:
        """Create an instance of ListVersionsResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in versions (list)
        _items = []
        if self.versions:
            for _item in self.versions:
                if _item:
                    _items.append(_item.to_dict())
            _dict['versions'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in custom_learn_blocks (list)
        _items = []
        if self.custom_learn_blocks:
            for _item in self.custom_learn_blocks:
                if _item:
                    _items.append(_item.to_dict())
            _dict['customLearnBlocks'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ListVersionsResponse:
        """Create an instance of ListVersionsResponse from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ListVersionsResponse.construct(**obj)

        _obj = ListVersionsResponse.construct(**{
            "success": obj.get("success"),
            "error": obj.get("error"),
            "next_version": obj.get("nextVersion"),
            "versions": [ListVersionsResponseAllOfVersions.from_dict(_item) for _item in obj.get("versions")] if obj.get("versions") is not None else None,
            "custom_learn_blocks": [ListVersionsResponseAllOfCustomLearnBlocks.from_dict(_item) for _item in obj.get("customLearnBlocks")] if obj.get("customLearnBlocks") is not None else None,
            "run_model_testing_while_versioning": obj.get("runModelTestingWhileVersioning")
        })
        return _obj

