# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, StrictInt
from edgeimpulse_api.models.metadata_filter_options_options_list_inner import MetadataFilterOptionsOptionsListInner

class MetadataFilterOptions(BaseModel):
    total_count: StrictInt = Field(..., alias="totalCount")
    count: StrictInt = ...
    options_list: List[MetadataFilterOptionsOptionsListInner] = Field(..., alias="optionsList", description="Available metadata filter options that can be supplied to the /raw-data/ endpoint to filter samples")
    __properties = ["totalCount", "count", "optionsList"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> MetadataFilterOptions:
        """Create an instance of MetadataFilterOptions from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in options_list (list)
        _items = []
        if self.options_list:
            for _item in self.options_list:
                if _item:
                    _items.append(_item.to_dict())
            _dict['optionsList'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MetadataFilterOptions:
        """Create an instance of MetadataFilterOptions from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return MetadataFilterOptions.construct(**obj)

        _obj = MetadataFilterOptions.construct(**{
            "total_count": obj.get("totalCount"),
            "count": obj.get("count"),
            "options_list": [MetadataFilterOptionsOptionsListInner.from_dict(_item) for _item in obj.get("optionsList")] if obj.get("optionsList") is not None else None
        })
        return _obj

