# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from edgeimpulse_api.models.o_auth_scope import OAuthScope
from edgeimpulse_api.models.oauth_grant_type import OauthGrantType

class OauthClient(BaseModel):
    id: StrictInt = Field(..., description="Internal database identifier for the OAuth client. This value is used only within the system and is not exposed to or used by the OAuth client itself. ")
    client_id: StrictStr = Field(..., alias="clientId", description="The public, unique identifier assigned to the OAuth client. This value is shared with the client application and is used to identify the client during OAuth authentication and authorization flows. ")
    name: StrictStr = Field(..., description="Human-readable name of the OAuth client application.")
    description: Optional[StrictStr] = Field(None, description="Human-readable description providing details about the OAuth client application and its purpose.")
    redirect_uris: Optional[List[StrictStr]] = Field(None, alias="redirectUris", description="List of allowed redirect URIs for the OAuth client. After successful authorization, users are redirected to one of these URIs. Only these URIs are permitted to prevent redirection attacks. ")
    allowed_grant_types: Optional[List[OauthGrantType]] = Field(None, alias="allowedGrantTypes", description="List of OAuth 2.0 grant types that the client is permitted to use. Common values include 'authorization_code', 'client_credentials', 'refresh_token', etc. ")
    scopes: Optional[List[OAuthScope]] = Field(None, description="List of OAuth scopes that the client is allowed to request. Scopes define the level of access the client has to user resources. For example, 'projects:read', 'projects:write', etc. ")
    created_at: datetime = Field(..., alias="createdAt", description="Timestamp indicating when the OAuth client was registered.")
    created_by_user_id: StrictInt = Field(..., alias="createdByUserId", description="Unique identifier of the user who registered the OAuth client.")
    created_by_user_name: Optional[StrictStr] = Field(None, alias="createdByUserName", description="Name of the user who registered the OAuth client.")
    created_by_user_email: Optional[StrictStr] = Field(None, alias="createdByUserEmail", description="Email address of the user who registered the OAuth client.")
    requires_consent: Optional[StrictBool] = Field(None, alias="requiresConsent", description="Indicates whether this OAuth client requires explicit user consent. Internal clients may not require consent.")
    logo_url: Optional[StrictStr] = Field(None, alias="logoUrl", description="URL of the OAuth client logo.")
    owner_name: Optional[StrictStr] = Field(None, alias="ownerName", description="Name of the owner of the OAuth client.")
    owner_url: Optional[StrictStr] = Field(None, alias="ownerUrl", description="URL of the owner of the OAuth client.")
    __properties = ["id", "clientId", "name", "description", "redirectUris", "allowedGrantTypes", "scopes", "createdAt", "createdByUserId", "createdByUserName", "createdByUserEmail", "requiresConsent", "logoUrl", "ownerName", "ownerUrl"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> OauthClient:
        """Create an instance of OauthClient from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OauthClient:
        """Create an instance of OauthClient from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return OauthClient.construct(**obj)

        _obj = OauthClient.construct(**{
            "id": obj.get("id"),
            "client_id": obj.get("clientId"),
            "name": obj.get("name"),
            "description": obj.get("description"),
            "redirect_uris": obj.get("redirectUris"),
            "allowed_grant_types": obj.get("allowedGrantTypes"),
            "scopes": obj.get("scopes"),
            "created_at": obj.get("createdAt"),
            "created_by_user_id": obj.get("createdByUserId"),
            "created_by_user_name": obj.get("createdByUserName"),
            "created_by_user_email": obj.get("createdByUserEmail"),
            "requires_consent": obj.get("requiresConsent"),
            "logo_url": obj.get("logoUrl"),
            "owner_name": obj.get("ownerName"),
            "owner_url": obj.get("ownerUrl")
        })
        return _obj

