# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, validator
from edgeimpulse_api.models.created_updated_by_user import CreatedUpdatedByUser
from edgeimpulse_api.models.organization_create_project_transformation_summary import OrganizationCreateProjectTransformationSummary
from edgeimpulse_api.models.transformation_job_operates_on_enum import TransformationJobOperatesOnEnum
from edgeimpulse_api.models.transformation_job_status_enum import TransformationJobStatusEnum

class OrganizationCreateProject(BaseModel):
    id: StrictInt = ...
    organization_id: StrictInt = Field(..., alias="organizationId")
    name: StrictStr = ...
    upload_type: StrictStr = Field(..., alias="uploadType")
    status: TransformationJobStatusEnum = ...
    transform_job_status: TransformationJobStatusEnum = Field(..., alias="transformJobStatus")
    upload_job_id: Optional[StrictInt] = Field(None, alias="uploadJobId")
    upload_job_status: TransformationJobStatusEnum = Field(..., alias="uploadJobStatus")
    upload_job_files_uploaded: Optional[StrictInt] = Field(None, alias="uploadJobFilesUploaded")
    project_owner: Optional[StrictStr] = Field(None, alias="projectOwner")
    project_id: Optional[StrictInt] = Field(None, alias="projectId")
    project_name: Optional[StrictStr] = Field(None, alias="projectName")
    transformation_block_id: Optional[StrictInt] = Field(None, alias="transformationBlockId")
    builtin_transformation_block: Optional[Dict[str, Any]] = Field(None, alias="builtinTransformationBlock")
    transformation_block_name: Optional[StrictStr] = Field(None, alias="transformationBlockName")
    category: StrictStr = ...
    created: datetime = ...
    output_dataset_name: Optional[StrictStr] = Field(None, alias="outputDatasetName")
    output_dataset_bucket_id: Optional[StrictInt] = Field(None, alias="outputDatasetBucketId")
    output_dataset_bucket_path: Optional[StrictStr] = Field(None, alias="outputDatasetBucketPath")
    total_download_file_count: StrictInt = Field(..., alias="totalDownloadFileCount")
    total_download_file_size: StrictInt = Field(..., alias="totalDownloadFileSize")
    total_download_file_size_string: StrictStr = Field(..., alias="totalDownloadFileSizeString")
    total_upload_file_count: StrictInt = Field(..., alias="totalUploadFileCount")
    transformation_parallel: StrictInt = Field(..., alias="transformationParallel", description="Number of transformation jobs that can be ran in parallel")
    transformation_summary: OrganizationCreateProjectTransformationSummary = Field(..., alias="transformationSummary")
    in_progress: StrictBool = Field(..., alias="inProgress")
    label: Optional[StrictStr] = None
    filter_query: Optional[StrictStr] = Field(None, alias="filterQuery")
    email_recipient_uids: Optional[List[StrictInt]] = Field(None, alias="emailRecipientUids")
    pipeline_id: Optional[StrictInt] = Field(None, alias="pipelineId")
    pipeline_name: Optional[StrictStr] = Field(None, alias="pipelineName")
    pipeline_run_id: Optional[StrictInt] = Field(None, alias="pipelineRunId")
    pipeline_step: Optional[StrictInt] = Field(None, alias="pipelineStep")
    operates_on: TransformationJobOperatesOnEnum = Field(..., alias="operatesOn")
    total_time_spent_seconds: StrictInt = Field(..., alias="totalTimeSpentSeconds", description="Total amount of compute used for this job (in seconds)")
    total_time_spent_string: StrictStr = Field(..., alias="totalTimeSpentString", description="Total amount of compute used (friendly string)")
    created_by_user: Optional[CreatedUpdatedByUser] = Field(None, alias="createdByUser")
    __properties = ["id", "organizationId", "name", "uploadType", "status", "transformJobStatus", "uploadJobId", "uploadJobStatus", "uploadJobFilesUploaded", "projectOwner", "projectId", "projectName", "transformationBlockId", "builtinTransformationBlock", "transformationBlockName", "category", "created", "outputDatasetName", "outputDatasetBucketId", "outputDatasetBucketPath", "totalDownloadFileCount", "totalDownloadFileSize", "totalDownloadFileSizeString", "totalUploadFileCount", "transformationParallel", "transformationSummary", "inProgress", "label", "filterQuery", "emailRecipientUids", "pipelineId", "pipelineName", "pipelineRunId", "pipelineStep", "operatesOn", "totalTimeSpentSeconds", "totalTimeSpentString", "createdByUser"]

    @validator('upload_type')
    def upload_type_validate_enum(cls, v):
        if v not in ('dataset', 'project'):
            raise ValueError("must validate the enum values ('dataset', 'project')")
        return v

    @validator('category')
    def category_validate_enum(cls, v):
        if v not in ('training', 'testing', 'split'):
            raise ValueError("must validate the enum values ('training', 'testing', 'split')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> OrganizationCreateProject:
        """Create an instance of OrganizationCreateProject from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of transformation_summary
        if self.transformation_summary:
            _dict['transformationSummary'] = self.transformation_summary.to_dict()
        # override the default output from pydantic by calling `to_dict()` of created_by_user
        if self.created_by_user:
            _dict['createdByUser'] = self.created_by_user.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OrganizationCreateProject:
        """Create an instance of OrganizationCreateProject from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return OrganizationCreateProject.construct(**obj)

        _obj = OrganizationCreateProject.construct(**{
            "id": obj.get("id"),
            "organization_id": obj.get("organizationId"),
            "name": obj.get("name"),
            "upload_type": obj.get("uploadType"),
            "status": obj.get("status"),
            "transform_job_status": obj.get("transformJobStatus"),
            "upload_job_id": obj.get("uploadJobId"),
            "upload_job_status": obj.get("uploadJobStatus"),
            "upload_job_files_uploaded": obj.get("uploadJobFilesUploaded"),
            "project_owner": obj.get("projectOwner"),
            "project_id": obj.get("projectId"),
            "project_name": obj.get("projectName"),
            "transformation_block_id": obj.get("transformationBlockId"),
            "builtin_transformation_block": obj.get("builtinTransformationBlock"),
            "transformation_block_name": obj.get("transformationBlockName"),
            "category": obj.get("category"),
            "created": obj.get("created"),
            "output_dataset_name": obj.get("outputDatasetName"),
            "output_dataset_bucket_id": obj.get("outputDatasetBucketId"),
            "output_dataset_bucket_path": obj.get("outputDatasetBucketPath"),
            "total_download_file_count": obj.get("totalDownloadFileCount"),
            "total_download_file_size": obj.get("totalDownloadFileSize"),
            "total_download_file_size_string": obj.get("totalDownloadFileSizeString"),
            "total_upload_file_count": obj.get("totalUploadFileCount"),
            "transformation_parallel": obj.get("transformationParallel"),
            "transformation_summary": OrganizationCreateProjectTransformationSummary.from_dict(obj.get("transformationSummary")) if obj.get("transformationSummary") is not None else None,
            "in_progress": obj.get("inProgress"),
            "label": obj.get("label"),
            "filter_query": obj.get("filterQuery"),
            "email_recipient_uids": obj.get("emailRecipientUids"),
            "pipeline_id": obj.get("pipelineId"),
            "pipeline_name": obj.get("pipelineName"),
            "pipeline_run_id": obj.get("pipelineRunId"),
            "pipeline_step": obj.get("pipelineStep"),
            "operates_on": obj.get("operatesOn"),
            "total_time_spent_seconds": obj.get("totalTimeSpentSeconds"),
            "total_time_spent_string": obj.get("totalTimeSpentString"),
            "created_by_user": CreatedUpdatedByUser.from_dict(obj.get("createdByUser")) if obj.get("createdByUser") is not None else None
        })
        return _obj

