# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, validator
from edgeimpulse_api.models.keras_model_variant_enum import KerasModelVariantEnum

class StartPostProcessingRequest(BaseModel):
    variant: KerasModelVariantEnum = ...
    dataset: StrictStr = Field(..., description="Which dataset to use")
    algorithm: StrictStr = Field(..., description="Which algorithm container to use")
    evaluation: StrictStr = Field(..., description="Which evaluation container to use")
    population: Optional[StrictInt] = Field(100, description="The population size for the genetic algorithm")
    max_generations: Optional[StrictInt] = Field(100, alias="maxGenerations", description="The maximum number of generations for the genetic algorithm")
    design_space_tolerance: Optional[float] = Field(0.01, alias="designSpaceTolerance", description="The tolerance for the design space")
    objective_space_tolerance: Optional[float] = Field(0.0025, alias="objectiveSpaceTolerance", description="The tolerance for the objective space")
    termination_period: Optional[StrictInt] = Field(5, alias="terminationPeriod", description="The number of generations the termination criteria are averaged across")
    __properties = ["variant", "dataset", "algorithm", "evaluation", "population", "maxGenerations", "designSpaceTolerance", "objectiveSpaceTolerance", "terminationPeriod"]

    @validator('dataset')
    def dataset_validate_enum(cls, v):
        if v not in ('training', 'validation', 'testing'):
            raise ValueError("must validate the enum values ('training', 'validation', 'testing')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> StartPostProcessingRequest:
        """Create an instance of StartPostProcessingRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> StartPostProcessingRequest:
        """Create an instance of StartPostProcessingRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return StartPostProcessingRequest.construct(**obj)

        _obj = StartPostProcessingRequest.construct(**{
            "variant": obj.get("variant"),
            "dataset": obj.get("dataset"),
            "algorithm": obj.get("algorithm"),
            "evaluation": obj.get("evaluation"),
            "population": obj.get("population") if obj.get("population") is not None else 100,
            "max_generations": obj.get("maxGenerations") if obj.get("maxGenerations") is not None else 100,
            "design_space_tolerance": obj.get("designSpaceTolerance") if obj.get("designSpaceTolerance") is not None else 0.01,
            "objective_space_tolerance": obj.get("objectiveSpaceTolerance") if obj.get("objectiveSpaceTolerance") is not None else 0.0025,
            "termination_period": obj.get("terminationPeriod") if obj.get("terminationPeriod") is not None else 5
        })
        return _obj

