# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr
from edgeimpulse_api.models.raw_data_category import RawDataCategory

class StartSamplingRequest(BaseModel):
    label: StrictStr = Field(..., description="Label to be used during sampling.")
    length_ms: StrictInt = Field(..., alias="lengthMs", description="Requested length of the sample (in ms).")
    category: RawDataCategory = ...
    interval_ms: float = Field(..., alias="intervalMs", description="Interval between samples (can be calculated like `1/hz * 1000`)")
    sensor: Optional[StrictStr] = Field(None, description="The sensor to sample from.")
    label_color: Optional[StrictStr] = Field(None, alias="labelColor", description="Text color of label displayed on supported clients. Value can be any supported CSS color value")
    collected_sample_count: Optional[float] = Field(None, alias="collectedSampleCount", description="A hint to supported clients to show the number of samples currently collected")
    target_sample_count: Optional[float] = Field(None, alias="targetSampleCount", description="A hint to supported clients to show the desired number of samples to be collected")
    __properties = ["label", "lengthMs", "category", "intervalMs", "sensor", "labelColor", "collectedSampleCount", "targetSampleCount"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> StartSamplingRequest:
        """Create an instance of StartSamplingRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> StartSamplingRequest:
        """Create an instance of StartSamplingRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return StartSamplingRequest.construct(**obj)

        _obj = StartSamplingRequest.construct(**{
            "label": obj.get("label"),
            "length_ms": obj.get("lengthMs"),
            "category": obj.get("category"),
            "interval_ms": obj.get("intervalMs"),
            "sensor": obj.get("sensor"),
            "label_color": obj.get("labelColor"),
            "collected_sample_count": obj.get("collectedSampleCount"),
            "target_sample_count": obj.get("targetSampleCount")
        })
        return _obj

