# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr
from edgeimpulse_api.models.block_type import BlockType
from edgeimpulse_api.models.dsp_group_item import DSPGroupItem
from edgeimpulse_api.models.tuner_block_variants_value import TunerBlockVariantsValue

class TunerBlock(BaseModel):
    type: StrictStr = ...
    title: StrictStr = ...
    block_type: BlockType = Field(..., alias="blockType")
    author: Optional[StrictStr] = None
    description: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    recommended: Optional[StrictBool] = None
    organization_model_id: Optional[float] = Field(None, alias="organizationModelId")
    params: Optional[Dict[str, DSPGroupItem]] = None
    default_config: Optional[Dict[str, Any]] = Field(None, alias="defaultConfig")
    variants: Optional[Dict[str, TunerBlockVariantsValue]] = None
    __properties = ["type", "title", "blockType", "author", "description", "name", "recommended", "organizationModelId", "params", "defaultConfig", "variants"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> TunerBlock:
        """Create an instance of TunerBlock from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each value in params (dict)
        _field_dict = {}
        if self.params:
            for _key in self.params:
                if self.params[_key]:
                    _field_dict[_key] = self.params[_key].to_dict()
            _dict['params'] = _field_dict
        # override the default output from pydantic by calling `to_dict()` of each value in variants (dict)
        _field_dict = {}
        if self.variants:
            for _key in self.variants:
                if self.variants[_key]:
                    _field_dict[_key] = self.variants[_key].to_dict()
            _dict['variants'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TunerBlock:
        """Create an instance of TunerBlock from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TunerBlock.construct(**obj)

        _obj = TunerBlock.construct(**{
            "type": obj.get("type"),
            "title": obj.get("title"),
            "block_type": obj.get("blockType"),
            "author": obj.get("author"),
            "description": obj.get("description"),
            "name": obj.get("name"),
            "recommended": obj.get("recommended"),
            "organization_model_id": obj.get("organizationModelId"),
            "params": { _k: DSPGroupItem.from_dict(_v) for _k, _v in obj.get("params", {}).items() },
            "default_config": obj.get("defaultConfig"),
            "variants": { _k: TunerBlockVariantsValue.from_dict(_v) for _k, _v in obj.get("variants", {}).items() }
        })
        return _obj

