# coding: utf-8

"""
    Edge Impulse API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr
from edgeimpulse_api.models.tuner_block_variants_value_search_space_templates_inner import TunerBlockVariantsValueSearchSpaceTemplatesInner

class TunerBlockVariantsValue(BaseModel):
    title: Optional[StrictStr] = None
    key: Optional[StrictStr] = None
    regression: Optional[StrictBool] = None
    object_detection: Optional[StrictBool] = Field(None, alias="objectDetection")
    project_data_type: Optional[StrictStr] = Field(None, alias="projectDataType")
    search_space_templates: Optional[List[TunerBlockVariantsValueSearchSpaceTemplatesInner]] = Field(None, alias="searchSpaceTemplates")
    params: Optional[Dict[str, List[Dict[str, Any]]]] = None
    __properties = ["title", "key", "regression", "objectDetection", "projectDataType", "searchSpaceTemplates", "params"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = False

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self,indent=None) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict(),indent=indent)

    @classmethod
    def from_json(cls, json_str: str) -> TunerBlockVariantsValue:
        """Create an instance of TunerBlockVariantsValue from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in search_space_templates (list)
        _items = []
        if self.search_space_templates:
            for _item in self.search_space_templates:
                if _item:
                    _items.append(_item.to_dict())
            _dict['searchSpaceTemplates'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TunerBlockVariantsValue:
        """Create an instance of TunerBlockVariantsValue from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TunerBlockVariantsValue.construct(**obj)

        _obj = TunerBlockVariantsValue.construct(**{
            "title": obj.get("title"),
            "key": obj.get("key"),
            "regression": obj.get("regression"),
            "object_detection": obj.get("objectDetection"),
            "project_data_type": obj.get("projectDataType"),
            "search_space_templates": [TunerBlockVariantsValueSearchSpaceTemplatesInner.from_dict(_item) for _item in obj.get("searchSpaceTemplates")] if obj.get("searchSpaceTemplates") is not None else None,
            "params": obj.get("params")
        })
        return _obj

