# Release notes for MASSpy 0.2.0

## New features

* Installation and setup updates based on the following PEP guidelines:

    - [PEP 440](https://www.python.org/dev/peps/pep-0440/)
    - [PEP 517](https://www.python.org/dev/peps/pep-0517/)
    - [PEP 518](https://www.python.org/dev/peps/pep-0518/)
    - [PEP 566](https://www.python.org/dev/peps/pep-0566/)

* MASSpy now contains several new tools for standardized testing and development!

    - New CI-CD testing workflow in **run-tests.yml** for GitHub actions and
      coverage using [CodeCov](https://codecov.io/)
    - Configuration for tools is primarily in **pyproject.toml**. Options without
      `.toml` compatibility are in **setup.cfg**

#### Details for installation and setup updates.
* Apply `src/` layout to package
* Applied new PEP guidelines for setup using **pyproject.toml**
    - New file **pyproject.toml** for building package based on **setup.cfg**,
      [setuptools](https://setuptools.readthedocs.io/en/latest/setuptools.html),
      and [pypa/build](https://github.com/pypa/build).
    - New file **.bumpversion.cfg** to seperate `bumpversion` functions from **setup.cfg**.

        * Updates to release order in bumpversion based on PEP 440 release candidates.
          Excludes *preN.postM*, *preN.devM*, and *postN.devM* releases.

#### Standardized testing and development tools
* Implemented [tox](https://tox.readthedocs.io/en/latest/) for testing. Configuration is found in **pyproject.toml**.

    - Utilize `pytest` for testing, and coverage via `pytest-cov` for coverage reports.
    - Added `lint`, `safety`, and `py3{6,7} testing environments.

* Implemented [pre-commit](https://pre-commit.com/) for maintaining repository. Utilizes pre-commit hooks for

    - [isort](https://github.com/PyCQA/isort), [black](https://black.readthedocs.io/en/stable/), and [flake8](https://flake8.pycqa.org/en/3.8.4/) for linting.
    - Several additional [pre-commit hooks](https://github.com/pre-commit/pre-commit-hooks) and [pygrep hooks](https://github.com/pre-commit/pygrep-hooks)
      for formatting other file types.
    - Configuration found in new **.pre-commit-config.yaml**

* Added **.editorconfig** file with `isort` & `black` compatibility.

## Fixes

* Changes to `.github/workflows` files

    - Renamed the following files:

        * `python-publish.yml` --> `publish-pkg-pypi.yml`

    - Updated `publish-pkg-pypi.yml` to use new build.
    - Updated `python-publish.yml` and `publish-docker-images.yml` to activate only on final release tags, and allow test publishing for master branch in `python-publish.yml`.
    - Updates to sphinx documentation builder to account for new build.



## Deprecated features

## Backwards incompatible changes
