from http import HTTPStatus
from typing import Any, Optional, Union, cast

import httpx

from ...client import AuthenticatedClient, Client
from ...types import Response, UNSET
from ... import errors

from ...models.http_validation_error import HTTPValidationError
from ...models.kubernetes_cluster_model import KubernetesClusterModel
from typing import cast


def _get_kwargs(
    *,
    project: str,
) -> dict[str, Any]:
    params: dict[str, Any] = {}

    params["project"] = project

    params = {k: v for k, v in params.items() if v is not UNSET and v is not None}

    _kwargs: dict[str, Any] = {
        "method": "get",
        "url": "/v2/kubernetes/clusters",
        "params": params,
    }

    return _kwargs


def _parse_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Optional[Union[HTTPValidationError, list["KubernetesClusterModel"]]]:
    if response.status_code == 200:
        response_200 = []
        _response_200 = response.json()
        for response_200_item_data in _response_200:
            response_200_item = KubernetesClusterModel.from_dict(response_200_item_data)

            response_200.append(response_200_item)

        return response_200

    if response.status_code == 422:
        response_422 = HTTPValidationError.from_dict(response.json())

        return response_422

    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content)
    else:
        return None


def _build_response(
    *, client: Union[AuthenticatedClient, Client], response: httpx.Response
) -> Response[Union[HTTPValidationError, list["KubernetesClusterModel"]]]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    *,
    client: AuthenticatedClient,
    project: str,
) -> Response[Union[HTTPValidationError, list["KubernetesClusterModel"]]]:
    """Get Kubernetes Clusters

     Get all Kubernetes clusters for a project

    Args:
        project (str):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[HTTPValidationError, list['KubernetesClusterModel']]]
    """

    kwargs = _get_kwargs(
        project=project,
    )

    response = client.get_httpx_client().request(
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    *,
    client: AuthenticatedClient,
    project: str,
) -> Optional[Union[HTTPValidationError, list["KubernetesClusterModel"]]]:
    """Get Kubernetes Clusters

     Get all Kubernetes clusters for a project

    Args:
        project (str):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[HTTPValidationError, list['KubernetesClusterModel']]
    """

    return sync_detailed(
        client=client,
        project=project,
    ).parsed


async def asyncio_detailed(
    *,
    client: AuthenticatedClient,
    project: str,
) -> Response[Union[HTTPValidationError, list["KubernetesClusterModel"]]]:
    """Get Kubernetes Clusters

     Get all Kubernetes clusters for a project

    Args:
        project (str):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[Union[HTTPValidationError, list['KubernetesClusterModel']]]
    """

    kwargs = _get_kwargs(
        project=project,
    )

    response = await client.get_async_httpx_client().request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    *,
    client: AuthenticatedClient,
    project: str,
) -> Optional[Union[HTTPValidationError, list["KubernetesClusterModel"]]]:
    """Get Kubernetes Clusters

     Get all Kubernetes clusters for a project

    Args:
        project (str):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Union[HTTPValidationError, list['KubernetesClusterModel']]
    """

    return (
        await asyncio_detailed(
            client=client,
            project=project,
        )
    ).parsed
