# This file was auto-generated by Fern from our API Definition.

from ..core.unchecked_base_model import UncheckedBaseModel
import datetime as dt
import typing
from .assistant_message_content import AssistantMessageContent
import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class AssistantMessage(UncheckedBaseModel):
    """
    A message sent by the LLM in response to user input. Used in the LLM context.

    Args:
        id (str): The ID of the message
        date (datetime): The date the message was created in ISO format
        name (Optional[str]): The name of the sender of the message
        content (Union[str, List[LettaAssistantMessageContentUnion]]): The message content sent by the agent (can be a string or an array of content parts)
    """

    id: str
    date: dt.datetime
    name: typing.Optional[str] = None
    message_type: typing.Literal["assistant_message"] = "assistant_message"
    otid: typing.Optional[str] = None
    sender_id: typing.Optional[str] = None
    step_id: typing.Optional[str] = None
    is_err: typing.Optional[bool] = None
    content: AssistantMessageContent = pydantic.Field()
    """
    The message content sent by the agent (can be a string or an array of content parts)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
