# This file was auto-generated by Fern from our API Definition.

from ..core.unchecked_base_model import UncheckedBaseModel
import pydantic
from .identity_property_value import IdentityPropertyValue
from .identity_property_type import IdentityPropertyType
from ..core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class IdentityProperty(UncheckedBaseModel):
    """
    A property of an identity
    """

    key: str = pydantic.Field()
    """
    The key of the property
    """

    value: IdentityPropertyValue = pydantic.Field()
    """
    The value of the property
    """

    type: IdentityPropertyType = pydantic.Field()
    """
    The type of the property
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
