# This file was auto-generated by Fern from our API Definition.

from ..core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class ReasoningContent(UncheckedBaseModel):
    type: typing.Literal["reasoning"] = "reasoning"
    is_native: bool = pydantic.Field()
    """
    Whether the reasoning content was generated by a reasoner model that processed this step.
    """

    reasoning: str = pydantic.Field()
    """
    The intermediate reasoning or thought process content.
    """

    signature: typing.Optional[str] = pydantic.Field(default=None)
    """
    A unique identifier for this reasoning step.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
