# This file was auto-generated by Fern from our API Definition.

from ..core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2


class ToolCallContent(UncheckedBaseModel):
    type: typing.Literal["tool_return"] = "tool_return"
    id: str = pydantic.Field()
    """
    A unique identifier for this specific tool call instance.
    """

    name: str = pydantic.Field()
    """
    The name of the tool being called.
    """

    input: typing.Dict[str, typing.Optional[typing.Any]] = pydantic.Field()
    """
    The parameters being passed to the tool, structured as a dictionary of parameter names to values.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
