<a id="mypy-boto3-groundstation"></a>

# mypy-boto3-groundstation

[![PyPI - mypy-boto3-groundstation](https://img.shields.io/pypi/v/mypy-boto3-groundstation.svg?color=blue)](https://pypi.org/project/mypy-boto3-groundstation)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-groundstation.svg?color=blue)](https://pypi.org/project/mypy-boto3-groundstation)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-groundstation?color=blue)](https://pypistats.org/packages/mypy-boto3-groundstation)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.GroundStation 1.18.57](https://boto3.amazonaws.com/v1/documentation/api/1.18.57/reference/services/groundstation.html#GroundStation)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.5.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-groundstation docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_groundstation/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-groundstation](#mypy-boto3-groundstation)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `GroundStation` service.

```bash
python -m pip install boto3-stubs[groundstation]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[groundstation]` in your environment:
  `python -m pip install 'boto3-stubs[groundstation]'`

Both type checking and auto-complete should work for `GroundStation` service.
No explicit type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[groundstation]` in your environment:
  `python -m pip install 'boto3-stubs[groundstation]'`

Both type checking and auto-complete should work for `GroundStation` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[groundstation]` in your environment:
  `python -m pip install 'boto3-stubs[groundstation]'`
- Run `mypy` as usual

Type checking should work for `GroundStation` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[groundstation]` in your environment:
  `python -m pip install 'boto3-stubs[groundstation]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `GroundStation` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`GroundStationClient` provides annotations for `boto3.client("groundstation")`.

```python
import boto3

from mypy_boto3_groundstation import GroundStationClient

client: GroundStationClient = boto3.client("groundstation")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: GroundStationClient = session.client("groundstation")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_groundstation.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_groundstation import GroundStationClient
from mypy_boto3_groundstation.paginator import (
    ListConfigsPaginator,
    ListContactsPaginator,
    ListDataflowEndpointGroupsPaginator,
    ListGroundStationsPaginator,
    ListMissionProfilesPaginator,
    ListSatellitesPaginator,
)

client: GroundStationClient = boto3.client("groundstation")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_configs_paginator: ListConfigsPaginator = client.get_paginator("list_configs")
list_contacts_paginator: ListContactsPaginator = client.get_paginator("list_contacts")
list_dataflow_endpoint_groups_paginator: ListDataflowEndpointGroupsPaginator = client.get_paginator("list_dataflow_endpoint_groups")
list_ground_stations_paginator: ListGroundStationsPaginator = client.get_paginator("list_ground_stations")
list_mission_profiles_paginator: ListMissionProfilesPaginator = client.get_paginator("list_mission_profiles")
list_satellites_paginator: ListSatellitesPaginator = client.get_paginator("list_satellites")
```

<a id="literals"></a>

### Literals

`mypy_boto3_groundstation.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_groundstation.literals import (
    AngleUnitsType,
    BandwidthUnitsType,
    ConfigCapabilityTypeType,
    ContactStatusType,
    CriticalityType,
    EirpUnitsType,
    EndpointStatusType,
    FrequencyUnitsType,
    ListConfigsPaginatorName,
    ListContactsPaginatorName,
    ListDataflowEndpointGroupsPaginatorName,
    ListGroundStationsPaginatorName,
    ListMissionProfilesPaginatorName,
    ListSatellitesPaginatorName,
    PolarizationType,
    ServiceName,
    PaginatorName,
)

def check_value(value: AngleUnitsType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_groundstation.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_groundstation.type_defs import (
    AntennaDemodDecodeDetailsTypeDef,
    AntennaDownlinkConfigTypeDef,
    AntennaDownlinkDemodDecodeConfigTypeDef,
    AntennaUplinkConfigTypeDef,
    CancelContactRequestRequestTypeDef,
    ConfigDetailsTypeDef,
    ConfigIdResponseTypeDef,
    ConfigListItemTypeDef,
    ConfigTypeDataTypeDef,
    ContactDataTypeDef,
    ContactIdResponseTypeDef,
    CreateConfigRequestRequestTypeDef,
    CreateDataflowEndpointGroupRequestRequestTypeDef,
    CreateMissionProfileRequestRequestTypeDef,
    DataflowDetailTypeDef,
    DataflowEndpointConfigTypeDef,
    DataflowEndpointGroupIdResponseTypeDef,
    DataflowEndpointListItemTypeDef,
    DataflowEndpointTypeDef,
    DecodeConfigTypeDef,
    DeleteConfigRequestRequestTypeDef,
    DeleteDataflowEndpointGroupRequestRequestTypeDef,
    DeleteMissionProfileRequestRequestTypeDef,
    DemodulationConfigTypeDef,
    DescribeContactRequestRequestTypeDef,
    DescribeContactResponseTypeDef,
    DestinationTypeDef,
    EirpTypeDef,
    ElevationTypeDef,
    EndpointDetailsTypeDef,
    FrequencyBandwidthTypeDef,
    FrequencyTypeDef,
    GetConfigRequestRequestTypeDef,
    GetConfigResponseTypeDef,
    GetDataflowEndpointGroupRequestRequestTypeDef,
    GetDataflowEndpointGroupResponseTypeDef,
    GetMinuteUsageRequestRequestTypeDef,
    GetMinuteUsageResponseTypeDef,
    GetMissionProfileRequestRequestTypeDef,
    GetMissionProfileResponseTypeDef,
    GetSatelliteRequestRequestTypeDef,
    GetSatelliteResponseTypeDef,
    GroundStationDataTypeDef,
    ListConfigsRequestRequestTypeDef,
    ListConfigsResponseTypeDef,
    ListContactsRequestRequestTypeDef,
    ListContactsResponseTypeDef,
    ListDataflowEndpointGroupsRequestRequestTypeDef,
    ListDataflowEndpointGroupsResponseTypeDef,
    ListGroundStationsRequestRequestTypeDef,
    ListGroundStationsResponseTypeDef,
    ListMissionProfilesRequestRequestTypeDef,
    ListMissionProfilesResponseTypeDef,
    ListSatellitesRequestRequestTypeDef,
    ListSatellitesResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    MissionProfileIdResponseTypeDef,
    MissionProfileListItemTypeDef,
    PaginatorConfigTypeDef,
    ReserveContactRequestRequestTypeDef,
    ResponseMetadataTypeDef,
    S3RecordingConfigTypeDef,
    S3RecordingDetailsTypeDef,
    SatelliteListItemTypeDef,
    SecurityDetailsTypeDef,
    SocketAddressTypeDef,
    SourceTypeDef,
    SpectrumConfigTypeDef,
    TagResourceRequestRequestTypeDef,
    TrackingConfigTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateConfigRequestRequestTypeDef,
    UpdateMissionProfileRequestRequestTypeDef,
    UplinkEchoConfigTypeDef,
    UplinkSpectrumConfigTypeDef,
)

def get_structure() -> AntennaDemodDecodeDetailsTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-groundstation` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-groundstation docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_groundstation/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
