import { WebSocketRouteIntegration, WebSocketRouteIntegrationBindOptions, WebSocketRouteIntegrationConfig } from '@aws-cdk/aws-apigatewayv2';
import { IFunction } from '@aws-cdk/aws-lambda';
/**
 * Lambda WebSocket Integration
 */
export declare class WebSocketLambdaIntegration extends WebSocketRouteIntegration {
    private readonly handler;
    private readonly _id;
    /**
     * @param id id of the underlying integration construct
     * @param handler the Lambda function handler
     * @param props properties to configure the integration
     */
    constructor(id: string, handler: IFunction);
    bind(options: WebSocketRouteIntegrationBindOptions): WebSocketRouteIntegrationConfig;
}
