# coding: utf-8

"""
    Conekta API

    Conekta sdk

    The version of the OpenAPI document: 2.2.0
    Contact: engineering@conekta.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from conekta.models.payment_method_bnpl_request import PaymentMethodBnplRequest
from conekta.models.payment_method_card_request import PaymentMethodCardRequest
from conekta.models.payment_method_general_request import PaymentMethodGeneralRequest
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

CHARGEREQUESTPAYMENTMETHOD_ONE_OF_SCHEMAS = ["PaymentMethodBnplRequest", "PaymentMethodCardRequest", "PaymentMethodGeneralRequest"]

class ChargeRequestPaymentMethod(BaseModel):
    """
    ChargeRequestPaymentMethod
    """
    # data type: PaymentMethodBnplRequest
    oneof_schema_1_validator: Optional[PaymentMethodBnplRequest] = None
    # data type: PaymentMethodCardRequest
    oneof_schema_2_validator: Optional[PaymentMethodCardRequest] = None
    # data type: PaymentMethodGeneralRequest
    oneof_schema_3_validator: Optional[PaymentMethodGeneralRequest] = None
    actual_instance: Optional[Union[PaymentMethodBnplRequest, PaymentMethodCardRequest, PaymentMethodGeneralRequest]] = None
    one_of_schemas: Set[str] = { "PaymentMethodBnplRequest", "PaymentMethodCardRequest", "PaymentMethodGeneralRequest" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = ChargeRequestPaymentMethod.model_construct()
        error_messages = []
        match = 0
        # validate data type: PaymentMethodBnplRequest
        if not isinstance(v, PaymentMethodBnplRequest):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PaymentMethodBnplRequest`")
        else:
            match += 1
        # validate data type: PaymentMethodCardRequest
        if not isinstance(v, PaymentMethodCardRequest):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PaymentMethodCardRequest`")
        else:
            match += 1
        # validate data type: PaymentMethodGeneralRequest
        if not isinstance(v, PaymentMethodGeneralRequest):
            error_messages.append(f"Error! Input type `{type(v)}` is not `PaymentMethodGeneralRequest`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in ChargeRequestPaymentMethod with oneOf schemas: PaymentMethodBnplRequest, PaymentMethodCardRequest, PaymentMethodGeneralRequest. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in ChargeRequestPaymentMethod with oneOf schemas: PaymentMethodBnplRequest, PaymentMethodCardRequest, PaymentMethodGeneralRequest. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into PaymentMethodBnplRequest
        try:
            instance.actual_instance = PaymentMethodBnplRequest.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PaymentMethodCardRequest
        try:
            instance.actual_instance = PaymentMethodCardRequest.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into PaymentMethodGeneralRequest
        try:
            instance.actual_instance = PaymentMethodGeneralRequest.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into ChargeRequestPaymentMethod with oneOf schemas: PaymentMethodBnplRequest, PaymentMethodCardRequest, PaymentMethodGeneralRequest. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into ChargeRequestPaymentMethod with oneOf schemas: PaymentMethodBnplRequest, PaymentMethodCardRequest, PaymentMethodGeneralRequest. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], PaymentMethodBnplRequest, PaymentMethodCardRequest, PaymentMethodGeneralRequest]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


