# coding: utf-8

"""
    Conekta API

    Conekta sdk

    The version of the OpenAPI document: 2.2.0
    Contact: engineering@conekta.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from conekta.models.checkout_order_template import CheckoutOrderTemplate
from typing import Optional, Set
from typing_extensions import Self

class Checkout(BaseModel):
    """
    It is a sub-resource of the Order model that can be stipulated in order to configure its corresponding checkout
    """ # noqa: E501
    allowed_payment_methods: List[StrictStr] = Field(description="Those are the payment methods that will be available for the link")
    expires_at: StrictInt = Field(description="It is the time when the link will expire. It is expressed in seconds since the Unix epoch. The valid range is from 2 to 365 days (the valid range will be taken from the next day of the creation date at 00:01 hrs) ")
    monthly_installments_enabled: Optional[StrictBool] = Field(default=None, description="This flag allows you to specify if months without interest will be active.")
    monthly_installments_options: Optional[List[StrictInt]] = Field(default=None, description="This field allows you to specify the number of months without interest.")
    three_ds_mode: Optional[StrictStr] = Field(default=None, description="Indicates the 3DS2 mode for the order, either smart or strict.")
    name: StrictStr = Field(description="Reason for charge")
    needs_shipping_contact: Optional[StrictBool] = Field(default=None, description="This flag allows you to fill in the shipping information at checkout.")
    on_demand_enabled: Optional[StrictBool] = Field(default=None, description="This flag allows you to specify if the link will be on demand.")
    order_template: CheckoutOrderTemplate
    payments_limit_count: Optional[StrictInt] = Field(default=None, description="It is the number of payments that can be made through the link.")
    recurrent: StrictBool = Field(description="false: single use. true: multiple payments")
    type: StrictStr = Field(description="It is the type of link that will be created. It must be a valid type.")
    __properties: ClassVar[List[str]] = ["allowed_payment_methods", "expires_at", "monthly_installments_enabled", "monthly_installments_options", "three_ds_mode", "name", "needs_shipping_contact", "on_demand_enabled", "order_template", "payments_limit_count", "recurrent", "type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Checkout from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of order_template
        if self.order_template:
            _dict['order_template'] = self.order_template.to_dict()
        # set to None if on_demand_enabled (nullable) is None
        # and model_fields_set contains the field
        if self.on_demand_enabled is None and "on_demand_enabled" in self.model_fields_set:
            _dict['on_demand_enabled'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Checkout from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "allowed_payment_methods": obj.get("allowed_payment_methods"),
            "expires_at": obj.get("expires_at"),
            "monthly_installments_enabled": obj.get("monthly_installments_enabled"),
            "monthly_installments_options": obj.get("monthly_installments_options"),
            "three_ds_mode": obj.get("three_ds_mode"),
            "name": obj.get("name"),
            "needs_shipping_contact": obj.get("needs_shipping_contact"),
            "on_demand_enabled": obj.get("on_demand_enabled"),
            "order_template": CheckoutOrderTemplate.from_dict(obj["order_template"]) if obj.get("order_template") is not None else None,
            "payments_limit_count": obj.get("payments_limit_count"),
            "recurrent": obj.get("recurrent"),
            "type": obj.get("type")
        })
        return _obj


