# coding: utf-8

"""
    Conekta API

    Conekta sdk

    The version of the OpenAPI document: 2.2.0
    Contact: engineering@conekta.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from conekta.models.company_response_documents_inner import CompanyResponseDocumentsInner
from typing import Optional, Set
from typing_extensions import Self

class CompanyResponse(BaseModel):
    """
    CompanyResponse
    """ # noqa: E501
    id: StrictStr = Field(description="The unique identifier for the company.")
    name: StrictStr = Field(description="The name of the company.")
    active: StrictBool = Field(description="Indicates if the company is active.")
    account_status: StrictStr = Field(description="The current status of the company's account.")
    parent_company_id: Optional[StrictStr] = Field(default=None, description="The identifier of the parent company, if any.")
    onboarding_status: StrictStr = Field(description="The current status of the company's onboarding process.")
    documents: List[CompanyResponseDocumentsInner] = Field(description="A list of documents related to the company.")
    created_at: StrictInt = Field(description="Timestamp of when the company was created.")
    object: StrictStr = Field(description="The type of object, typically \"company\".")
    __properties: ClassVar[List[str]] = ["id", "name", "active", "account_status", "parent_company_id", "onboarding_status", "documents", "created_at", "object"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CompanyResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in documents (list)
        _items = []
        if self.documents:
            for _item_documents in self.documents:
                if _item_documents:
                    _items.append(_item_documents.to_dict())
            _dict['documents'] = _items
        # set to None if parent_company_id (nullable) is None
        # and model_fields_set contains the field
        if self.parent_company_id is None and "parent_company_id" in self.model_fields_set:
            _dict['parent_company_id'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CompanyResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "active": obj.get("active"),
            "account_status": obj.get("account_status"),
            "parent_company_id": obj.get("parent_company_id"),
            "onboarding_status": obj.get("onboarding_status"),
            "documents": [CompanyResponseDocumentsInner.from_dict(_item) for _item in obj["documents"]] if obj.get("documents") is not None else None,
            "created_at": obj.get("created_at"),
            "object": obj.get("object")
        })
        return _obj


