# coding: utf-8

"""
    Conekta API

    Conekta sdk

    The version of the OpenAPI document: 2.2.0
    Contact: engineering@conekta.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import json
import pprint
from pydantic import BaseModel, ConfigDict, Field, StrictStr, ValidationError, field_validator
from typing import Any, List, Optional
from conekta.models.customer_info import CustomerInfo
from conekta.models.customer_info_just_customer_id import CustomerInfoJustCustomerId
from pydantic import StrictStr, Field
from typing import Union, List, Set, Optional, Dict
from typing_extensions import Literal, Self

ORDERREQUESTCUSTOMERINFO_ONE_OF_SCHEMAS = ["CustomerInfo", "CustomerInfoJustCustomerId"]

class OrderRequestCustomerInfo(BaseModel):
    """
    Customer information
    """
    # data type: CustomerInfo
    oneof_schema_1_validator: Optional[CustomerInfo] = None
    # data type: CustomerInfoJustCustomerId
    oneof_schema_2_validator: Optional[CustomerInfoJustCustomerId] = None
    actual_instance: Optional[Union[CustomerInfo, CustomerInfoJustCustomerId]] = None
    one_of_schemas: Set[str] = { "CustomerInfo", "CustomerInfoJustCustomerId" }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )


    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        instance = OrderRequestCustomerInfo.model_construct()
        error_messages = []
        match = 0
        # validate data type: CustomerInfo
        if not isinstance(v, CustomerInfo):
            error_messages.append(f"Error! Input type `{type(v)}` is not `CustomerInfo`")
        else:
            match += 1
        # validate data type: CustomerInfoJustCustomerId
        if not isinstance(v, CustomerInfoJustCustomerId):
            error_messages.append(f"Error! Input type `{type(v)}` is not `CustomerInfoJustCustomerId`")
        else:
            match += 1
        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when setting `actual_instance` in OrderRequestCustomerInfo with oneOf schemas: CustomerInfo, CustomerInfoJustCustomerId. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when setting `actual_instance` in OrderRequestCustomerInfo with oneOf schemas: CustomerInfo, CustomerInfoJustCustomerId. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into CustomerInfo
        try:
            instance.actual_instance = CustomerInfo.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into CustomerInfoJustCustomerId
        try:
            instance.actual_instance = CustomerInfoJustCustomerId.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into OrderRequestCustomerInfo with oneOf schemas: CustomerInfo, CustomerInfoJustCustomerId. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into OrderRequestCustomerInfo with oneOf schemas: CustomerInfo, CustomerInfoJustCustomerId. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], CustomerInfo, CustomerInfoJustCustomerId]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())


