# coding: utf-8

"""
    Conekta API

    Conekta sdk

    The version of the OpenAPI document: 2.2.0
    Contact: engineering@conekta.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from conekta.models.order_channel_response import OrderChannelResponse
from conekta.models.order_charges_response import OrderChargesResponse
from conekta.models.order_discount_lines_response import OrderDiscountLinesResponse
from conekta.models.order_fiscal_entity_response import OrderFiscalEntityResponse
from conekta.models.order_next_action_response import OrderNextActionResponse
from conekta.models.order_response_checkout import OrderResponseCheckout
from conekta.models.order_response_customer_info import OrderResponseCustomerInfo
from conekta.models.order_response_products import OrderResponseProducts
from conekta.models.order_response_shipping_contact import OrderResponseShippingContact
from typing import Optional, Set
from typing_extensions import Self

class OrderResponse(BaseModel):
    """
    order response
    """ # noqa: E501
    amount: Optional[StrictInt] = Field(default=None, description="The total amount to be collected in cents")
    amount_refunded: Optional[StrictInt] = Field(default=None, description="The total amount refunded in cents")
    channel: Optional[OrderChannelResponse] = None
    charges: Optional[OrderChargesResponse] = None
    checkout: Optional[OrderResponseCheckout] = None
    created_at: Optional[StrictInt] = Field(default=None, description="The time at which the object was created in seconds since the Unix epoch")
    currency: Optional[StrictStr] = Field(default=None, description="The three-letter ISO 4217 currency code. The currency of the order.")
    customer_info: Optional[OrderResponseCustomerInfo] = None
    discount_lines: Optional[OrderDiscountLinesResponse] = None
    fiscal_entity: Optional[OrderFiscalEntityResponse] = None
    id: Optional[StrictStr] = None
    is_refundable: Optional[StrictBool] = None
    line_items: Optional[OrderResponseProducts] = None
    livemode: Optional[StrictBool] = Field(default=None, description="Whether the object exists in live mode or test mode")
    metadata: Optional[Dict[str, Any]] = Field(default=None, description="Set of key-value pairs that you can attach to an object. This can be useful for storing additional information about the object in a structured format.")
    next_action: Optional[OrderNextActionResponse] = None
    object: Optional[StrictStr] = Field(default=None, description="String representing the object’s type. Objects of the same type share the same value.")
    payment_status: Optional[StrictStr] = Field(default=None, description="The payment status of the order.")
    processing_mode: Optional[StrictStr] = Field(default=None, description="Indicates the processing mode for the order, either ecommerce, recurrent or validation.")
    shipping_contact: Optional[OrderResponseShippingContact] = None
    updated_at: Optional[StrictInt] = Field(default=None, description="The time at which the object was last updated in seconds since the Unix epoch")
    __properties: ClassVar[List[str]] = ["amount", "amount_refunded", "channel", "charges", "checkout", "created_at", "currency", "customer_info", "discount_lines", "fiscal_entity", "id", "is_refundable", "line_items", "livemode", "metadata", "next_action", "object", "payment_status", "processing_mode", "shipping_contact", "updated_at"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrderResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of channel
        if self.channel:
            _dict['channel'] = self.channel.to_dict()
        # override the default output from pydantic by calling `to_dict()` of charges
        if self.charges:
            _dict['charges'] = self.charges.to_dict()
        # override the default output from pydantic by calling `to_dict()` of checkout
        if self.checkout:
            _dict['checkout'] = self.checkout.to_dict()
        # override the default output from pydantic by calling `to_dict()` of customer_info
        if self.customer_info:
            _dict['customer_info'] = self.customer_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of discount_lines
        if self.discount_lines:
            _dict['discount_lines'] = self.discount_lines.to_dict()
        # override the default output from pydantic by calling `to_dict()` of fiscal_entity
        if self.fiscal_entity:
            _dict['fiscal_entity'] = self.fiscal_entity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of line_items
        if self.line_items:
            _dict['line_items'] = self.line_items.to_dict()
        # override the default output from pydantic by calling `to_dict()` of next_action
        if self.next_action:
            _dict['next_action'] = self.next_action.to_dict()
        # override the default output from pydantic by calling `to_dict()` of shipping_contact
        if self.shipping_contact:
            _dict['shipping_contact'] = self.shipping_contact.to_dict()
        # set to None if fiscal_entity (nullable) is None
        # and model_fields_set contains the field
        if self.fiscal_entity is None and "fiscal_entity" in self.model_fields_set:
            _dict['fiscal_entity'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrderResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "amount": obj.get("amount"),
            "amount_refunded": obj.get("amount_refunded"),
            "channel": OrderChannelResponse.from_dict(obj["channel"]) if obj.get("channel") is not None else None,
            "charges": OrderChargesResponse.from_dict(obj["charges"]) if obj.get("charges") is not None else None,
            "checkout": OrderResponseCheckout.from_dict(obj["checkout"]) if obj.get("checkout") is not None else None,
            "created_at": obj.get("created_at"),
            "currency": obj.get("currency"),
            "customer_info": OrderResponseCustomerInfo.from_dict(obj["customer_info"]) if obj.get("customer_info") is not None else None,
            "discount_lines": OrderDiscountLinesResponse.from_dict(obj["discount_lines"]) if obj.get("discount_lines") is not None else None,
            "fiscal_entity": OrderFiscalEntityResponse.from_dict(obj["fiscal_entity"]) if obj.get("fiscal_entity") is not None else None,
            "id": obj.get("id"),
            "is_refundable": obj.get("is_refundable"),
            "line_items": OrderResponseProducts.from_dict(obj["line_items"]) if obj.get("line_items") is not None else None,
            "livemode": obj.get("livemode"),
            "metadata": obj.get("metadata"),
            "next_action": OrderNextActionResponse.from_dict(obj["next_action"]) if obj.get("next_action") is not None else None,
            "object": obj.get("object"),
            "payment_status": obj.get("payment_status"),
            "processing_mode": obj.get("processing_mode"),
            "shipping_contact": OrderResponseShippingContact.from_dict(obj["shipping_contact"]) if obj.get("shipping_contact") is not None else None,
            "updated_at": obj.get("updated_at")
        })
        return _obj


