# coding: utf-8

"""
    Conekta API

    Conekta sdk

    The version of the OpenAPI document: 2.2.0
    Contact: engineering@conekta.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class PaymentMethodBnplRequest(BaseModel):
    """
    PaymentMethodBnplRequest
    """ # noqa: E501
    type: StrictStr = Field(description="Type of the payment method")
    cancel_url: StrictStr = Field(description="URL to redirect the customer after a canceled payment")
    can_not_expire: StrictBool = Field(description="Indicates if the payment method can not expire")
    failure_url: StrictStr = Field(description="URL to redirect the customer after a failed payment")
    product_type: StrictStr = Field(description="Product type of the payment method, use for the payment method to know the product type")
    success_url: StrictStr = Field(description="URL to redirect the customer after a successful payment")
    __properties: ClassVar[List[str]] = ["type", "cancel_url", "can_not_expire", "failure_url", "product_type", "success_url"]

    @field_validator('product_type')
    def product_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['aplazo_bnpl', 'creditea_bnpl']):
            raise ValueError("must be one of enum values ('aplazo_bnpl', 'creditea_bnpl')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PaymentMethodBnplRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PaymentMethodBnplRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "cancel_url": obj.get("cancel_url"),
            "can_not_expire": obj.get("can_not_expire"),
            "failure_url": obj.get("failure_url"),
            "product_type": obj.get("product_type"),
            "success_url": obj.get("success_url")
        })
        return _obj


