# coding: utf-8

"""
    Conekta API

    Conekta sdk

    The version of the OpenAPI document: 2.2.0
    Contact: engineering@conekta.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class PaymentMethodCardResponse(BaseModel):
    """
    PaymentMethodCardResponse
    """ # noqa: E501
    type: StrictStr
    id: StrictStr
    object: StrictStr
    created_at: StrictInt
    parent_id: Optional[StrictStr] = None
    last4: Optional[StrictStr] = None
    bin: Optional[StrictStr] = None
    card_type: Optional[StrictStr] = None
    exp_month: Optional[StrictStr] = None
    exp_year: Optional[StrictStr] = None
    brand: Optional[StrictStr] = None
    name: Optional[StrictStr] = None
    default: Optional[StrictBool] = None
    visible_on_checkout: Optional[StrictBool] = None
    payment_source_status: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["type", "id", "object", "created_at", "parent_id", "last4", "bin", "card_type", "exp_month", "exp_year", "brand", "name", "default", "visible_on_checkout", "payment_source_status"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PaymentMethodCardResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PaymentMethodCardResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "type": obj.get("type"),
            "id": obj.get("id"),
            "object": obj.get("object"),
            "created_at": obj.get("created_at"),
            "parent_id": obj.get("parent_id"),
            "last4": obj.get("last4"),
            "bin": obj.get("bin"),
            "card_type": obj.get("card_type"),
            "exp_month": obj.get("exp_month"),
            "exp_year": obj.get("exp_year"),
            "brand": obj.get("brand"),
            "name": obj.get("name"),
            "default": obj.get("default"),
            "visible_on_checkout": obj.get("visible_on_checkout"),
            "payment_source_status": obj.get("payment_source_status")
        })
        return _obj


