# coding: utf-8

"""
    Conekta API

    Conekta sdk

    The version of the OpenAPI document: 2.2.0
    Contact: engineering@conekta.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from conekta.models.customer_info_just_customer_id import CustomerInfoJustCustomerId
from conekta.models.payout import Payout
from typing import Optional, Set
from typing_extensions import Self

class PayoutOrder(BaseModel):
    """
    a payout order
    """ # noqa: E501
    allowed_payout_methods: List[StrictStr] = Field(description="The payout methods that are allowed for the payout order.")
    amount: StrictInt = Field(description="The amount of the payout order.")
    currency: StrictStr = Field(description="The currency in which the payout order is made.")
    customer_info: CustomerInfoJustCustomerId
    metadata: Optional[Dict[str, Any]] = Field(default=None, description="The metadata of the payout order.")
    payout: Payout
    reason: StrictStr = Field(description="The reason for the payout order.")
    __properties: ClassVar[List[str]] = ["allowed_payout_methods", "amount", "currency", "customer_info", "metadata", "payout", "reason"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PayoutOrder from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of customer_info
        if self.customer_info:
            _dict['customer_info'] = self.customer_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of payout
        if self.payout:
            _dict['payout'] = self.payout.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PayoutOrder from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "allowed_payout_methods": obj.get("allowed_payout_methods"),
            "amount": obj.get("amount"),
            "currency": obj.get("currency") if obj.get("currency") is not None else 'MXN',
            "customer_info": CustomerInfoJustCustomerId.from_dict(obj["customer_info"]) if obj.get("customer_info") is not None else None,
            "metadata": obj.get("metadata"),
            "payout": Payout.from_dict(obj["payout"]) if obj.get("payout") is not None else None,
            "reason": obj.get("reason")
        })
        return _obj


