# coding: utf-8

"""
    Conekta API

    Conekta sdk

    The version of the OpenAPI document: 2.2.0
    Contact: engineering@conekta.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class TransactionResponse(BaseModel):
    """
    The Transaction object represents the actions or steps of an order. Statuses can be: unprocessed, pending, available, owen, paid_out, voided, capture, capture_reversal, liquidation, liquidation_reversal, payout, payout_reversal, refund, refund_reversal, chargeback, chargeback_reversal, rounding_adjustment, won_chargeback, transferred, and transferred.
    """ # noqa: E501
    amount: StrictInt = Field(description="The amount of the transaction.")
    charge: StrictStr = Field(description="Randomly assigned unique order identifier associated with the charge.")
    created_at: StrictInt = Field(description="Date and time of creation of the transaction in Unix format.")
    currency: Annotated[str, Field(strict=True, max_length=3)] = Field(description="The currency of the transaction. It uses the 3-letter code of the [International Standard ISO 4217.](https://es.wikipedia.org/wiki/ISO_4217)")
    fee: StrictInt = Field(description="The amount to be deducted for taxes and commissions.")
    id: StrictStr = Field(description="Unique identifier of the transaction.")
    livemode: StrictBool = Field(description="Indicates whether the transaction was created in live mode or test mode.")
    net: StrictInt = Field(description="The net amount after deducting commissions and taxes.")
    object: StrictStr = Field(description="Object name, which is transaction.")
    status: StrictStr = Field(description="Code indicating transaction status.")
    type: StrictStr = Field(description="Transaction Type")
    __properties: ClassVar[List[str]] = ["amount", "charge", "created_at", "currency", "fee", "id", "livemode", "net", "object", "status", "type"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TransactionResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TransactionResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "amount": obj.get("amount"),
            "charge": obj.get("charge"),
            "created_at": obj.get("created_at"),
            "currency": obj.get("currency"),
            "fee": obj.get("fee"),
            "id": obj.get("id"),
            "livemode": obj.get("livemode"),
            "net": obj.get("net"),
            "object": obj.get("object"),
            "status": obj.get("status"),
            "type": obj.get("type")
        })
        return _obj


