# coding: utf-8

"""
    Conekta API

    Conekta sdk

    The version of the OpenAPI document: 2.2.0
    Contact: engineering@conekta.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class WebhookResponse(BaseModel):
    """
    webhooks model
    """ # noqa: E501
    id: Optional[StrictStr] = Field(default=None, description="id of the webhook")
    description: Optional[StrictStr] = Field(default=None, description="A name or brief explanation of what this webhook is used for")
    livemode: Optional[StrictBool] = Field(default=None, description="Indicates if the webhook is in production")
    active: Optional[StrictBool] = Field(default=None, description="Indicates if the webhook is actived or not")
    object: Optional[StrictStr] = Field(default=None, description="Object name, value is 'webhook'")
    status: Optional[StrictStr] = Field(default=None, description="Indicates if the webhook is ready to receive events or failing")
    subscribed_events: Optional[List[StrictStr]] = Field(default=None, description="lists the events that will be sent to the webhook")
    url: Optional[StrictStr] = Field(default=None, description="url or endpoint of the webhook")
    __properties: ClassVar[List[str]] = ["id", "description", "livemode", "active", "object", "status", "subscribed_events", "url"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebhookResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebhookResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "description": obj.get("description"),
            "livemode": obj.get("livemode"),
            "active": obj.get("active"),
            "object": obj.get("object"),
            "status": obj.get("status"),
            "subscribed_events": obj.get("subscribed_events"),
            "url": obj.get("url")
        })
        return _obj


