import pytest
from python.answer_displayers.TextField import TextFieldDisplayer

_TEST_INPUTS = _TEST_OUTPUTS = [
    "ghjghj",
    "Test Name",
    "E2E Automated Test Project",
    "Constituency",
]


@pytest.mark.parametrize(
    "answer, expected_result",
    zip(_TEST_INPUTS, _TEST_OUTPUTS),
)
def test_as_csv(answer, expected_result):
    assert TextFieldDisplayer(answer).as_csv == expected_result


@pytest.mark.parametrize(
    "answer, expected_result",
    zip(_TEST_INPUTS, _TEST_OUTPUTS),
)
def test_as_txt(answer, expected_result):
    assert TextFieldDisplayer(answer).as_txt == expected_result


@pytest.mark.parametrize(
    "answer, expected_result",
    zip(_TEST_INPUTS, _TEST_OUTPUTS),
)
def test_as_pdf(answer, expected_result):
    assert TextFieldDisplayer(answer).as_pdf == expected_result
