"""
    QApp Platform Project oqc_cloud_provider.py Copyright © CITYNOW Co. Ltd. All rights reserved.
"""
from qcaas_client.client import OQCClient

from qapp_common.enum.provider_tag import ProviderTag
from qapp_common.model.provider.provider import Provider
from qapp_common.config.logging_config import logger


class OqcCloudProvider(Provider):
    def __init__(self, oqc_cloud_url: str, access_token: str):
        super().__init__(ProviderTag.OQC_CLOUD)
        self.oqc_cloud_url = oqc_cloud_url
        self.access_token = access_token

    def get_backend(self, device_specification):
        logger.debug("[OqcCloudProvider] get_backend()")

        return self.collect_provider()

    def collect_provider(self):
        logger.debug("[OqcCloudProvider] collect_provider()")

        return OQCClient(url=self.oqc_cloud_url, authentication_token=self.access_token)
