# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc
import warnings

from . import duckdb_service_pb2 as duckdb__service__pb2

GRPC_GENERATED_VERSION = '1.75.1'
GRPC_VERSION = grpc.__version__
_version_not_supported = False

try:
    from grpc._utilities import first_version_is_lower
    _version_not_supported = first_version_is_lower(GRPC_VERSION, GRPC_GENERATED_VERSION)
except ImportError:
    _version_not_supported = True

if _version_not_supported:
    raise RuntimeError(
        f'The grpc package installed is at version {GRPC_VERSION},'
        + f' but the generated code in duckdb_service_pb2_grpc.py depends on'
        + f' grpcio>={GRPC_GENERATED_VERSION}.'
        + f' Please upgrade your grpc module to grpcio>={GRPC_GENERATED_VERSION}'
        + f' or downgrade your generated code using grpcio-tools<={GRPC_VERSION}.'
    )


class DuckDBServiceStub(object):
    """========================================
    DuckDB 数据分析服务
    ========================================
    DuckDB 是一个嵌入式 OLAP 数据库，专为分析查询优化
    特点：
    - 数据库文件存储在 MinIO 中，实现持久化和用户隔离
    - 支持 SQL 查询（兼容 PostgreSQL 语法）
    - 高性能列式存储
    - 支持 Parquet、CSV、JSON 等多种数据格式
    - 可直接查询 MinIO 中的文件（无需导入）
    - 适用场景：数据分析、BI 报表、数据科学

    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.CreateDatabase = channel.unary_unary(
                '/isa.duckdb.DuckDBService/CreateDatabase',
                request_serializer=duckdb__service__pb2.CreateDatabaseRequest.SerializeToString,
                response_deserializer=duckdb__service__pb2.CreateDatabaseResponse.FromString,
                _registered_method=True)
        self.ListDatabases = channel.unary_unary(
                '/isa.duckdb.DuckDBService/ListDatabases',
                request_serializer=duckdb__service__pb2.ListDatabasesRequest.SerializeToString,
                response_deserializer=duckdb__service__pb2.ListDatabasesResponse.FromString,
                _registered_method=True)
        self.DeleteDatabase = channel.unary_unary(
                '/isa.duckdb.DuckDBService/DeleteDatabase',
                request_serializer=duckdb__service__pb2.DeleteDatabaseRequest.SerializeToString,
                response_deserializer=duckdb__service__pb2.DeleteDatabaseResponse.FromString,
                _registered_method=True)
        self.GetDatabaseInfo = channel.unary_unary(
                '/isa.duckdb.DuckDBService/GetDatabaseInfo',
                request_serializer=duckdb__service__pb2.GetDatabaseInfoRequest.SerializeToString,
                response_deserializer=duckdb__service__pb2.GetDatabaseInfoResponse.FromString,
                _registered_method=True)
        self.BackupDatabase = channel.unary_unary(
                '/isa.duckdb.DuckDBService/BackupDatabase',
                request_serializer=duckdb__service__pb2.BackupDatabaseRequest.SerializeToString,
                response_deserializer=duckdb__service__pb2.BackupDatabaseResponse.FromString,
                _registered_method=True)
        self.RestoreDatabase = channel.unary_unary(
                '/isa.duckdb.DuckDBService/RestoreDatabase',
                request_serializer=duckdb__service__pb2.RestoreDatabaseRequest.SerializeToString,
                response_deserializer=duckdb__service__pb2.RestoreDatabaseResponse.FromString,
                _registered_method=True)
        self.ExecuteQuery = channel.unary_unary(
                '/isa.duckdb.DuckDBService/ExecuteQuery',
                request_serializer=duckdb__service__pb2.ExecuteQueryRequest.SerializeToString,
                response_deserializer=duckdb__service__pb2.ExecuteQueryResponse.FromString,
                _registered_method=True)
        self.ExecuteQueryStream = channel.unary_stream(
                '/isa.duckdb.DuckDBService/ExecuteQueryStream',
                request_serializer=duckdb__service__pb2.ExecuteQueryRequest.SerializeToString,
                response_deserializer=duckdb__service__pb2.QueryResultChunk.FromString,
                _registered_method=True)
        self.ExecuteStatement = channel.unary_unary(
                '/isa.duckdb.DuckDBService/ExecuteStatement',
                request_serializer=duckdb__service__pb2.ExecuteStatementRequest.SerializeToString,
                response_deserializer=duckdb__service__pb2.ExecuteStatementResponse.FromString,
                _registered_method=True)
        self.ExecuteBatch = channel.unary_unary(
                '/isa.duckdb.DuckDBService/ExecuteBatch',
                request_serializer=duckdb__service__pb2.ExecuteBatchRequest.SerializeToString,
                response_deserializer=duckdb__service__pb2.ExecuteBatchResponse.FromString,
                _registered_method=True)
        self.PrepareStatement = channel.unary_unary(
                '/isa.duckdb.DuckDBService/PrepareStatement',
                request_serializer=duckdb__service__pb2.PrepareStatementRequest.SerializeToString,
                response_deserializer=duckdb__service__pb2.PrepareStatementResponse.FromString,
                _registered_method=True)
        self.CreateTable = channel.unary_unary(
                '/isa.duckdb.DuckDBService/CreateTable',
                request_serializer=duckdb__service__pb2.CreateTableRequest.SerializeToString,
                response_deserializer=duckdb__service__pb2.CreateTableResponse.FromString,
                _registered_method=True)
        self.ListTables = channel.unary_unary(
                '/isa.duckdb.DuckDBService/ListTables',
                request_serializer=duckdb__service__pb2.ListTablesRequest.SerializeToString,
                response_deserializer=duckdb__service__pb2.ListTablesResponse.FromString,
                _registered_method=True)
        self.DropTable = channel.unary_unary(
                '/isa.duckdb.DuckDBService/DropTable',
                request_serializer=duckdb__service__pb2.DropTableRequest.SerializeToString,
                response_deserializer=duckdb__service__pb2.DropTableResponse.FromString,
                _registered_method=True)
        self.GetTableSchema = channel.unary_unary(
                '/isa.duckdb.DuckDBService/GetTableSchema',
                request_serializer=duckdb__service__pb2.GetTableSchemaRequest.SerializeToString,
                response_deserializer=duckdb__service__pb2.GetTableSchemaResponse.FromString,
                _registered_method=True)
        self.GetTableStats = channel.unary_unary(
                '/isa.duckdb.DuckDBService/GetTableStats',
                request_serializer=duckdb__service__pb2.GetTableStatsRequest.SerializeToString,
                response_deserializer=duckdb__service__pb2.GetTableStatsResponse.FromString,
                _registered_method=True)
        self.CreateView = channel.unary_unary(
                '/isa.duckdb.DuckDBService/CreateView',
                request_serializer=duckdb__service__pb2.CreateViewRequest.SerializeToString,
                response_deserializer=duckdb__service__pb2.CreateViewResponse.FromString,
                _registered_method=True)
        self.ListViews = channel.unary_unary(
                '/isa.duckdb.DuckDBService/ListViews',
                request_serializer=duckdb__service__pb2.ListViewsRequest.SerializeToString,
                response_deserializer=duckdb__service__pb2.ListViewsResponse.FromString,
                _registered_method=True)
        self.DropView = channel.unary_unary(
                '/isa.duckdb.DuckDBService/DropView',
                request_serializer=duckdb__service__pb2.DropViewRequest.SerializeToString,
                response_deserializer=duckdb__service__pb2.DropViewResponse.FromString,
                _registered_method=True)
        self.ImportFromMinIO = channel.unary_unary(
                '/isa.duckdb.DuckDBService/ImportFromMinIO',
                request_serializer=duckdb__service__pb2.ImportFromMinIORequest.SerializeToString,
                response_deserializer=duckdb__service__pb2.ImportFromMinIOResponse.FromString,
                _registered_method=True)
        self.ExportToMinIO = channel.unary_unary(
                '/isa.duckdb.DuckDBService/ExportToMinIO',
                request_serializer=duckdb__service__pb2.ExportToMinIORequest.SerializeToString,
                response_deserializer=duckdb__service__pb2.ExportToMinIOResponse.FromString,
                _registered_method=True)
        self.QueryMinIOFile = channel.unary_unary(
                '/isa.duckdb.DuckDBService/QueryMinIOFile',
                request_serializer=duckdb__service__pb2.QueryMinIOFileRequest.SerializeToString,
                response_deserializer=duckdb__service__pb2.QueryMinIOFileResponse.FromString,
                _registered_method=True)
        self.ImportData = channel.stream_unary(
                '/isa.duckdb.DuckDBService/ImportData',
                request_serializer=duckdb__service__pb2.ImportDataRequest.SerializeToString,
                response_deserializer=duckdb__service__pb2.ImportDataResponse.FromString,
                _registered_method=True)
        self.InstallExtension = channel.unary_unary(
                '/isa.duckdb.DuckDBService/InstallExtension',
                request_serializer=duckdb__service__pb2.InstallExtensionRequest.SerializeToString,
                response_deserializer=duckdb__service__pb2.InstallExtensionResponse.FromString,
                _registered_method=True)
        self.ListExtensions = channel.unary_unary(
                '/isa.duckdb.DuckDBService/ListExtensions',
                request_serializer=duckdb__service__pb2.ListExtensionsRequest.SerializeToString,
                response_deserializer=duckdb__service__pb2.ListExtensionsResponse.FromString,
                _registered_method=True)
        self.CreateFunction = channel.unary_unary(
                '/isa.duckdb.DuckDBService/CreateFunction',
                request_serializer=duckdb__service__pb2.CreateFunctionRequest.SerializeToString,
                response_deserializer=duckdb__service__pb2.CreateFunctionResponse.FromString,
                _registered_method=True)
        self.HealthCheck = channel.unary_unary(
                '/isa.duckdb.DuckDBService/HealthCheck',
                request_serializer=duckdb__service__pb2.HealthCheckRequest.SerializeToString,
                response_deserializer=duckdb__service__pb2.HealthCheckResponse.FromString,
                _registered_method=True)
        self.GetMetrics = channel.unary_unary(
                '/isa.duckdb.DuckDBService/GetMetrics',
                request_serializer=duckdb__service__pb2.GetMetricsRequest.SerializeToString,
                response_deserializer=duckdb__service__pb2.GetMetricsResponse.FromString,
                _registered_method=True)


class DuckDBServiceServicer(object):
    """========================================
    DuckDB 数据分析服务
    ========================================
    DuckDB 是一个嵌入式 OLAP 数据库，专为分析查询优化
    特点：
    - 数据库文件存储在 MinIO 中，实现持久化和用户隔离
    - 支持 SQL 查询（兼容 PostgreSQL 语法）
    - 高性能列式存储
    - 支持 Parquet、CSV、JSON 等多种数据格式
    - 可直接查询 MinIO 中的文件（无需导入）
    - 适用场景：数据分析、BI 报表、数据科学

    """

    def CreateDatabase(self, request, context):
        """========== 数据库管理 ==========
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListDatabases(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def DeleteDatabase(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetDatabaseInfo(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def BackupDatabase(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def RestoreDatabase(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ExecuteQuery(self, request, context):
        """========== 查询操作 ==========
        执行 SQL 查询（返回完整结果）
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ExecuteQueryStream(self, request, context):
        """流式查询（适合大结果集）
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ExecuteStatement(self, request, context):
        """执行写操作（INSERT、UPDATE、DELETE）
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ExecuteBatch(self, request, context):
        """批量执行 SQL
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def PrepareStatement(self, request, context):
        """准备预编译语句
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def CreateTable(self, request, context):
        """========== 表管理 ==========
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListTables(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def DropTable(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetTableSchema(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetTableStats(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def CreateView(self, request, context):
        """========== 视图管理 ==========
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListViews(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def DropView(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ImportFromMinIO(self, request, context):
        """========== 数据导入/导出 ==========
        从 MinIO 导入数据
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ExportToMinIO(self, request, context):
        """导出数据到 MinIO
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def QueryMinIOFile(self, request, context):
        """直接查询 MinIO 中的文件（无需导入）
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ImportData(self, request_iterator, context):
        """流式导入数据
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def InstallExtension(self, request, context):
        """========== 扩展和函数 ==========
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def ListExtensions(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def CreateFunction(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def HealthCheck(self, request, context):
        """========== 健康检查和监控 ==========
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def GetMetrics(self, request, context):
        """Missing associated documentation comment in .proto file."""
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_DuckDBServiceServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'CreateDatabase': grpc.unary_unary_rpc_method_handler(
                    servicer.CreateDatabase,
                    request_deserializer=duckdb__service__pb2.CreateDatabaseRequest.FromString,
                    response_serializer=duckdb__service__pb2.CreateDatabaseResponse.SerializeToString,
            ),
            'ListDatabases': grpc.unary_unary_rpc_method_handler(
                    servicer.ListDatabases,
                    request_deserializer=duckdb__service__pb2.ListDatabasesRequest.FromString,
                    response_serializer=duckdb__service__pb2.ListDatabasesResponse.SerializeToString,
            ),
            'DeleteDatabase': grpc.unary_unary_rpc_method_handler(
                    servicer.DeleteDatabase,
                    request_deserializer=duckdb__service__pb2.DeleteDatabaseRequest.FromString,
                    response_serializer=duckdb__service__pb2.DeleteDatabaseResponse.SerializeToString,
            ),
            'GetDatabaseInfo': grpc.unary_unary_rpc_method_handler(
                    servicer.GetDatabaseInfo,
                    request_deserializer=duckdb__service__pb2.GetDatabaseInfoRequest.FromString,
                    response_serializer=duckdb__service__pb2.GetDatabaseInfoResponse.SerializeToString,
            ),
            'BackupDatabase': grpc.unary_unary_rpc_method_handler(
                    servicer.BackupDatabase,
                    request_deserializer=duckdb__service__pb2.BackupDatabaseRequest.FromString,
                    response_serializer=duckdb__service__pb2.BackupDatabaseResponse.SerializeToString,
            ),
            'RestoreDatabase': grpc.unary_unary_rpc_method_handler(
                    servicer.RestoreDatabase,
                    request_deserializer=duckdb__service__pb2.RestoreDatabaseRequest.FromString,
                    response_serializer=duckdb__service__pb2.RestoreDatabaseResponse.SerializeToString,
            ),
            'ExecuteQuery': grpc.unary_unary_rpc_method_handler(
                    servicer.ExecuteQuery,
                    request_deserializer=duckdb__service__pb2.ExecuteQueryRequest.FromString,
                    response_serializer=duckdb__service__pb2.ExecuteQueryResponse.SerializeToString,
            ),
            'ExecuteQueryStream': grpc.unary_stream_rpc_method_handler(
                    servicer.ExecuteQueryStream,
                    request_deserializer=duckdb__service__pb2.ExecuteQueryRequest.FromString,
                    response_serializer=duckdb__service__pb2.QueryResultChunk.SerializeToString,
            ),
            'ExecuteStatement': grpc.unary_unary_rpc_method_handler(
                    servicer.ExecuteStatement,
                    request_deserializer=duckdb__service__pb2.ExecuteStatementRequest.FromString,
                    response_serializer=duckdb__service__pb2.ExecuteStatementResponse.SerializeToString,
            ),
            'ExecuteBatch': grpc.unary_unary_rpc_method_handler(
                    servicer.ExecuteBatch,
                    request_deserializer=duckdb__service__pb2.ExecuteBatchRequest.FromString,
                    response_serializer=duckdb__service__pb2.ExecuteBatchResponse.SerializeToString,
            ),
            'PrepareStatement': grpc.unary_unary_rpc_method_handler(
                    servicer.PrepareStatement,
                    request_deserializer=duckdb__service__pb2.PrepareStatementRequest.FromString,
                    response_serializer=duckdb__service__pb2.PrepareStatementResponse.SerializeToString,
            ),
            'CreateTable': grpc.unary_unary_rpc_method_handler(
                    servicer.CreateTable,
                    request_deserializer=duckdb__service__pb2.CreateTableRequest.FromString,
                    response_serializer=duckdb__service__pb2.CreateTableResponse.SerializeToString,
            ),
            'ListTables': grpc.unary_unary_rpc_method_handler(
                    servicer.ListTables,
                    request_deserializer=duckdb__service__pb2.ListTablesRequest.FromString,
                    response_serializer=duckdb__service__pb2.ListTablesResponse.SerializeToString,
            ),
            'DropTable': grpc.unary_unary_rpc_method_handler(
                    servicer.DropTable,
                    request_deserializer=duckdb__service__pb2.DropTableRequest.FromString,
                    response_serializer=duckdb__service__pb2.DropTableResponse.SerializeToString,
            ),
            'GetTableSchema': grpc.unary_unary_rpc_method_handler(
                    servicer.GetTableSchema,
                    request_deserializer=duckdb__service__pb2.GetTableSchemaRequest.FromString,
                    response_serializer=duckdb__service__pb2.GetTableSchemaResponse.SerializeToString,
            ),
            'GetTableStats': grpc.unary_unary_rpc_method_handler(
                    servicer.GetTableStats,
                    request_deserializer=duckdb__service__pb2.GetTableStatsRequest.FromString,
                    response_serializer=duckdb__service__pb2.GetTableStatsResponse.SerializeToString,
            ),
            'CreateView': grpc.unary_unary_rpc_method_handler(
                    servicer.CreateView,
                    request_deserializer=duckdb__service__pb2.CreateViewRequest.FromString,
                    response_serializer=duckdb__service__pb2.CreateViewResponse.SerializeToString,
            ),
            'ListViews': grpc.unary_unary_rpc_method_handler(
                    servicer.ListViews,
                    request_deserializer=duckdb__service__pb2.ListViewsRequest.FromString,
                    response_serializer=duckdb__service__pb2.ListViewsResponse.SerializeToString,
            ),
            'DropView': grpc.unary_unary_rpc_method_handler(
                    servicer.DropView,
                    request_deserializer=duckdb__service__pb2.DropViewRequest.FromString,
                    response_serializer=duckdb__service__pb2.DropViewResponse.SerializeToString,
            ),
            'ImportFromMinIO': grpc.unary_unary_rpc_method_handler(
                    servicer.ImportFromMinIO,
                    request_deserializer=duckdb__service__pb2.ImportFromMinIORequest.FromString,
                    response_serializer=duckdb__service__pb2.ImportFromMinIOResponse.SerializeToString,
            ),
            'ExportToMinIO': grpc.unary_unary_rpc_method_handler(
                    servicer.ExportToMinIO,
                    request_deserializer=duckdb__service__pb2.ExportToMinIORequest.FromString,
                    response_serializer=duckdb__service__pb2.ExportToMinIOResponse.SerializeToString,
            ),
            'QueryMinIOFile': grpc.unary_unary_rpc_method_handler(
                    servicer.QueryMinIOFile,
                    request_deserializer=duckdb__service__pb2.QueryMinIOFileRequest.FromString,
                    response_serializer=duckdb__service__pb2.QueryMinIOFileResponse.SerializeToString,
            ),
            'ImportData': grpc.stream_unary_rpc_method_handler(
                    servicer.ImportData,
                    request_deserializer=duckdb__service__pb2.ImportDataRequest.FromString,
                    response_serializer=duckdb__service__pb2.ImportDataResponse.SerializeToString,
            ),
            'InstallExtension': grpc.unary_unary_rpc_method_handler(
                    servicer.InstallExtension,
                    request_deserializer=duckdb__service__pb2.InstallExtensionRequest.FromString,
                    response_serializer=duckdb__service__pb2.InstallExtensionResponse.SerializeToString,
            ),
            'ListExtensions': grpc.unary_unary_rpc_method_handler(
                    servicer.ListExtensions,
                    request_deserializer=duckdb__service__pb2.ListExtensionsRequest.FromString,
                    response_serializer=duckdb__service__pb2.ListExtensionsResponse.SerializeToString,
            ),
            'CreateFunction': grpc.unary_unary_rpc_method_handler(
                    servicer.CreateFunction,
                    request_deserializer=duckdb__service__pb2.CreateFunctionRequest.FromString,
                    response_serializer=duckdb__service__pb2.CreateFunctionResponse.SerializeToString,
            ),
            'HealthCheck': grpc.unary_unary_rpc_method_handler(
                    servicer.HealthCheck,
                    request_deserializer=duckdb__service__pb2.HealthCheckRequest.FromString,
                    response_serializer=duckdb__service__pb2.HealthCheckResponse.SerializeToString,
            ),
            'GetMetrics': grpc.unary_unary_rpc_method_handler(
                    servicer.GetMetrics,
                    request_deserializer=duckdb__service__pb2.GetMetricsRequest.FromString,
                    response_serializer=duckdb__service__pb2.GetMetricsResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'isa.duckdb.DuckDBService', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))
    server.add_registered_method_handlers('isa.duckdb.DuckDBService', rpc_method_handlers)


 # This class is part of an EXPERIMENTAL API.
class DuckDBService(object):
    """========================================
    DuckDB 数据分析服务
    ========================================
    DuckDB 是一个嵌入式 OLAP 数据库，专为分析查询优化
    特点：
    - 数据库文件存储在 MinIO 中，实现持久化和用户隔离
    - 支持 SQL 查询（兼容 PostgreSQL 语法）
    - 高性能列式存储
    - 支持 Parquet、CSV、JSON 等多种数据格式
    - 可直接查询 MinIO 中的文件（无需导入）
    - 适用场景：数据分析、BI 报表、数据科学

    """

    @staticmethod
    def CreateDatabase(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/isa.duckdb.DuckDBService/CreateDatabase',
            duckdb__service__pb2.CreateDatabaseRequest.SerializeToString,
            duckdb__service__pb2.CreateDatabaseResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ListDatabases(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/isa.duckdb.DuckDBService/ListDatabases',
            duckdb__service__pb2.ListDatabasesRequest.SerializeToString,
            duckdb__service__pb2.ListDatabasesResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def DeleteDatabase(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/isa.duckdb.DuckDBService/DeleteDatabase',
            duckdb__service__pb2.DeleteDatabaseRequest.SerializeToString,
            duckdb__service__pb2.DeleteDatabaseResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetDatabaseInfo(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/isa.duckdb.DuckDBService/GetDatabaseInfo',
            duckdb__service__pb2.GetDatabaseInfoRequest.SerializeToString,
            duckdb__service__pb2.GetDatabaseInfoResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def BackupDatabase(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/isa.duckdb.DuckDBService/BackupDatabase',
            duckdb__service__pb2.BackupDatabaseRequest.SerializeToString,
            duckdb__service__pb2.BackupDatabaseResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def RestoreDatabase(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/isa.duckdb.DuckDBService/RestoreDatabase',
            duckdb__service__pb2.RestoreDatabaseRequest.SerializeToString,
            duckdb__service__pb2.RestoreDatabaseResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ExecuteQuery(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/isa.duckdb.DuckDBService/ExecuteQuery',
            duckdb__service__pb2.ExecuteQueryRequest.SerializeToString,
            duckdb__service__pb2.ExecuteQueryResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ExecuteQueryStream(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_stream(
            request,
            target,
            '/isa.duckdb.DuckDBService/ExecuteQueryStream',
            duckdb__service__pb2.ExecuteQueryRequest.SerializeToString,
            duckdb__service__pb2.QueryResultChunk.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ExecuteStatement(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/isa.duckdb.DuckDBService/ExecuteStatement',
            duckdb__service__pb2.ExecuteStatementRequest.SerializeToString,
            duckdb__service__pb2.ExecuteStatementResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ExecuteBatch(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/isa.duckdb.DuckDBService/ExecuteBatch',
            duckdb__service__pb2.ExecuteBatchRequest.SerializeToString,
            duckdb__service__pb2.ExecuteBatchResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def PrepareStatement(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/isa.duckdb.DuckDBService/PrepareStatement',
            duckdb__service__pb2.PrepareStatementRequest.SerializeToString,
            duckdb__service__pb2.PrepareStatementResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def CreateTable(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/isa.duckdb.DuckDBService/CreateTable',
            duckdb__service__pb2.CreateTableRequest.SerializeToString,
            duckdb__service__pb2.CreateTableResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ListTables(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/isa.duckdb.DuckDBService/ListTables',
            duckdb__service__pb2.ListTablesRequest.SerializeToString,
            duckdb__service__pb2.ListTablesResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def DropTable(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/isa.duckdb.DuckDBService/DropTable',
            duckdb__service__pb2.DropTableRequest.SerializeToString,
            duckdb__service__pb2.DropTableResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetTableSchema(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/isa.duckdb.DuckDBService/GetTableSchema',
            duckdb__service__pb2.GetTableSchemaRequest.SerializeToString,
            duckdb__service__pb2.GetTableSchemaResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetTableStats(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/isa.duckdb.DuckDBService/GetTableStats',
            duckdb__service__pb2.GetTableStatsRequest.SerializeToString,
            duckdb__service__pb2.GetTableStatsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def CreateView(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/isa.duckdb.DuckDBService/CreateView',
            duckdb__service__pb2.CreateViewRequest.SerializeToString,
            duckdb__service__pb2.CreateViewResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ListViews(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/isa.duckdb.DuckDBService/ListViews',
            duckdb__service__pb2.ListViewsRequest.SerializeToString,
            duckdb__service__pb2.ListViewsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def DropView(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/isa.duckdb.DuckDBService/DropView',
            duckdb__service__pb2.DropViewRequest.SerializeToString,
            duckdb__service__pb2.DropViewResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ImportFromMinIO(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/isa.duckdb.DuckDBService/ImportFromMinIO',
            duckdb__service__pb2.ImportFromMinIORequest.SerializeToString,
            duckdb__service__pb2.ImportFromMinIOResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ExportToMinIO(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/isa.duckdb.DuckDBService/ExportToMinIO',
            duckdb__service__pb2.ExportToMinIORequest.SerializeToString,
            duckdb__service__pb2.ExportToMinIOResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def QueryMinIOFile(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/isa.duckdb.DuckDBService/QueryMinIOFile',
            duckdb__service__pb2.QueryMinIOFileRequest.SerializeToString,
            duckdb__service__pb2.QueryMinIOFileResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ImportData(request_iterator,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.stream_unary(
            request_iterator,
            target,
            '/isa.duckdb.DuckDBService/ImportData',
            duckdb__service__pb2.ImportDataRequest.SerializeToString,
            duckdb__service__pb2.ImportDataResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def InstallExtension(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/isa.duckdb.DuckDBService/InstallExtension',
            duckdb__service__pb2.InstallExtensionRequest.SerializeToString,
            duckdb__service__pb2.InstallExtensionResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def ListExtensions(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/isa.duckdb.DuckDBService/ListExtensions',
            duckdb__service__pb2.ListExtensionsRequest.SerializeToString,
            duckdb__service__pb2.ListExtensionsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def CreateFunction(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/isa.duckdb.DuckDBService/CreateFunction',
            duckdb__service__pb2.CreateFunctionRequest.SerializeToString,
            duckdb__service__pb2.CreateFunctionResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def HealthCheck(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/isa.duckdb.DuckDBService/HealthCheck',
            duckdb__service__pb2.HealthCheckRequest.SerializeToString,
            duckdb__service__pb2.HealthCheckResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)

    @staticmethod
    def GetMetrics(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(
            request,
            target,
            '/isa.duckdb.DuckDBService/GetMetrics',
            duckdb__service__pb2.GetMetricsRequest.SerializeToString,
            duckdb__service__pb2.GetMetricsResponse.FromString,
            options,
            channel_credentials,
            insecure,
            call_credentials,
            compression,
            wait_for_ready,
            timeout,
            metadata,
            _registered_method=True)
