# This file was auto-generated by Fern from our API Definition.

import typing
from contextlib import asynccontextmanager, contextmanager

import websockets.exceptions
import websockets.sync.client as websockets_sync_client
from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawApolloWsSessionClient, RawApolloWsSessionClient
from .socket_client import ApolloWsSessionSocketClient, AsyncApolloWsSessionSocketClient

try:
    from websockets.legacy.client import connect as websockets_client_connect  # type: ignore
except ImportError:
    from websockets import connect as websockets_client_connect  # type: ignore


class ApolloWsSessionClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawApolloWsSessionClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawApolloWsSessionClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawApolloWsSessionClient
        """
        return self._raw_client

    @contextmanager
    def connect(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Iterator[ApolloWsSessionSocketClient]:
        """
        WebSocket channel for real-time bidirectional communication with the agent

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ApolloWsSessionSocketClient
        """
        ws_url = self._raw_client._client_wrapper.get_environment().staging + "/ia-controller/api/v1/external/session"
        headers = self._raw_client._client_wrapper.get_headers()
        if request_options and "additional_headers" in request_options:
            headers.update(request_options["additional_headers"])
        try:
            with websockets_sync_client.connect(ws_url, additional_headers=headers) as protocol:
                yield ApolloWsSessionSocketClient(websocket=protocol)
        except websockets.exceptions.InvalidStatusCode as exc:
            status_code: int = exc.status_code
            if status_code == 401:
                raise ApiError(
                    status_code=status_code,
                    headers=dict(headers),
                    body="Websocket initialized with invalid credentials.",
                )
            raise ApiError(
                status_code=status_code,
                headers=dict(headers),
                body="Unexpected error when initializing websocket connection.",
            )


class AsyncApolloWsSessionClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawApolloWsSessionClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawApolloWsSessionClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawApolloWsSessionClient
        """
        return self._raw_client

    @asynccontextmanager
    async def connect(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.AsyncIterator[AsyncApolloWsSessionSocketClient]:
        """
        WebSocket channel for real-time bidirectional communication with the agent

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncApolloWsSessionSocketClient
        """
        ws_url = self._raw_client._client_wrapper.get_environment().staging + "/ia-controller/api/v1/external/session"
        headers = self._raw_client._client_wrapper.get_headers()
        if request_options and "additional_headers" in request_options:
            headers.update(request_options["additional_headers"])
        try:
            async with websockets_client_connect(ws_url, extra_headers=headers) as protocol:
                yield AsyncApolloWsSessionSocketClient(websocket=protocol)
        except websockets.exceptions.InvalidStatusCode as exc:
            status_code: int = exc.status_code
            if status_code == 401:
                raise ApiError(
                    status_code=status_code,
                    headers=dict(headers),
                    body="Websocket initialized with invalid credentials.",
                )
            raise ApiError(
                status_code=status_code,
                headers=dict(headers),
                body="Unexpected error when initializing websocket connection.",
            )
