# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import httpx
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .environment import ApolloClientEnvironment

if typing.TYPE_CHECKING:
    from .external_apis.client import AsyncExternalApisClient, ExternalApisClient


class ApolloClient:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    environment : ApolloClientEnvironment
        The environment to use for requests from the client. from .environment import ApolloClientEnvironment



        Defaults to ApolloClientEnvironment.DEFAULT



    network_api_key : typing.Optional[str]
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from aui import ApolloClient

    client = ApolloClient(
        network_api_key="YOUR_NETWORK_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        environment: ApolloClientEnvironment = ApolloClientEnvironment.DEFAULT,
        network_api_key: typing.Optional[str] = None,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = SyncClientWrapper(
            environment=environment,
            network_api_key=network_api_key,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._external_apis: typing.Optional[ExternalApisClient] = None

    @property
    def external_apis(self):
        if self._external_apis is None:
            from .external_apis.client import ExternalApisClient  # noqa: E402

            self._external_apis = ExternalApisClient(client_wrapper=self._client_wrapper)
        return self._external_apis


class AsyncApolloClient:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    environment : ApolloClientEnvironment
        The environment to use for requests from the client. from .environment import ApolloClientEnvironment



        Defaults to ApolloClientEnvironment.DEFAULT



    network_api_key : typing.Optional[str]
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from aui import AsyncApolloClient

    client = AsyncApolloClient(
        network_api_key="YOUR_NETWORK_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        environment: ApolloClientEnvironment = ApolloClientEnvironment.DEFAULT,
        network_api_key: typing.Optional[str] = None,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = AsyncClientWrapper(
            environment=environment,
            network_api_key=network_api_key,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._external_apis: typing.Optional[AsyncExternalApisClient] = None

    @property
    def external_apis(self):
        if self._external_apis is None:
            from .external_apis.client import AsyncExternalApisClient  # noqa: E402

            self._external_apis = AsyncExternalApisClient(client_wrapper=self._client_wrapper)
        return self._external_apis
