# This file was auto-generated by Fern from our API Definition.

import typing

import httpx
from ..environment import ApolloClientEnvironment
from .http_client import AsyncHttpClient, HttpClient


class BaseClientWrapper:
    def __init__(
        self,
        *,
        network_api_key: typing.Optional[str] = None,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        environment: ApolloClientEnvironment,
        timeout: typing.Optional[float] = None,
    ):
        self._network_api_key = network_api_key
        self._headers = headers
        self._environment = environment
        self._timeout = timeout

    def get_headers(self) -> typing.Dict[str, str]:
        headers: typing.Dict[str, str] = {
            "User-Agent": "aui-client/1.2.12",
            "X-Fern-Language": "Python",
            "X-Fern-SDK-Name": "aui-client",
            "X-Fern-SDK-Version": "1.2.12",
            **(self.get_custom_headers() or {}),
        }
        if self._network_api_key is not None:
            headers["x-network-api-key"] = self._network_api_key
        return headers

    def get_custom_headers(self) -> typing.Optional[typing.Dict[str, str]]:
        return self._headers

    def get_environment(self) -> ApolloClientEnvironment:
        return self._environment

    def get_timeout(self) -> typing.Optional[float]:
        return self._timeout


class SyncClientWrapper(BaseClientWrapper):
    def __init__(
        self,
        *,
        network_api_key: typing.Optional[str] = None,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        environment: ApolloClientEnvironment,
        timeout: typing.Optional[float] = None,
        httpx_client: httpx.Client,
    ):
        super().__init__(network_api_key=network_api_key, headers=headers, environment=environment, timeout=timeout)
        self.httpx_client = HttpClient(
            httpx_client=httpx_client, base_headers=self.get_headers, base_timeout=self.get_timeout
        )


class AsyncClientWrapper(BaseClientWrapper):
    def __init__(
        self,
        *,
        network_api_key: typing.Optional[str] = None,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        environment: ApolloClientEnvironment,
        timeout: typing.Optional[float] = None,
        httpx_client: httpx.AsyncClient,
    ):
        super().__init__(network_api_key=network_api_key, headers=headers, environment=environment, timeout=timeout)
        self.httpx_client = AsyncHttpClient(
            httpx_client=httpx_client, base_headers=self.get_headers, base_timeout=self.get_timeout
        )
